#!/usr/bin/bash
#
# Bash script to post-process files startphy_icosa.nc and start_icosa.nc
# generated by start_archive2icosa and create files
# start.nc and startphy.nc (usable as inputs for icosa_lmdz.exe)

# load nco module
module purge
LMDZ=${LMDZ:-../trunk/}  #You have to adapt to your own path, can be in your bashrc
source $LMDZ/XIOS/arch.env
#module load nco/4.7.9-gcc-4.8.5-hdf5-1.8.18-openmpi-2.0.4 #Example of version of the module needed
module load nco

#conversion to netcdf 3 in order to rename and add variables, not properly done with netcdf4 files
nccopy -k 'classic' startfi_prefinalize.nc startphy_icosa_nc3.nc

# rename lat and lon variables as latitude and longitude and put result in
# file startphy.nc
ncrename -v lon,longitude -v lat,latitude -d cell,physical_points\
         startphy_icosa_nc3.nc startphy_nc3.nc
#Temporay soildepth array from Dynamico restartfi
ncks -A -v soildepth restartfi.nc startphy_nc3.nc #You have to adapt to your own path
# ncks -A -v subslope_dist restartfi.nc startphy_nc3.nc
# ncks -A -v def_slope restartfi.nc startphy_nc3.nc

nccopy -k 4 startphy_nc3.nc startfi.nc

#Temporary Time variable from start2archive; should be added with xios
ncks -O -x -v time_counter startfi.nc startfi.nc_tmp
ncks -A -v Time start.nc startfi.nc_tmp
# ncks -A -v flux_geo restartfi.nc startfi.nc_tmp
# ncks -A -v wstar restartfi.nc startfi.nc_tmp
# ncks -A -v hmons restartfi.nc startfi.nc_tmp
# ncks -A -v summit restartfi.nc startfi.nc_tmp
# ncks -A -v base restartfi.nc startfi.nc_tmp
cp startfi.nc_tmp startfi.nc

./rearrange_startphy.e > rearrange_startphy.out 2>&1

# make a proper start.nc file based on start_icosa.nc
cp start_icosa_prefinalize.nc start_icosa.nc

# add u,u_lat,u_lon,bounds_lat_u and bound_lon_u from start_icosa_ref.nc
ncks -A -v u,lon_u,lat_u,bounds_lon_u,bounds_lat_u \
     start_icosa_ref.nc start_icosa.nc
ncrename -d cell,cell_mesh \
         start_icosa.nc
ncrename -d nvertex,nvertex_mesh \
         start_icosa.nc
ncks -A -v xcell,ycell,zcell \
     start_icosa_ref.nc start_icosa.nc

ncks -A -v W,geopot,q,nq start_icosa_ref.nc start_icosa.nc

# In the current version of Dynamico, the variable q for tracer is needed but unused.
# To create this unused variable simply run this short python code

# cleanup
rm -rf startphy_icosa_nc3.nc startphy_nc3.nc
