MODULE info_PEM_mod

implicit none

integer :: iPCM, iPEM, nPCM, nPCM_ini ! Data about the chained simulation of PCM/PEM runs

!=======================================================================
contains
!=======================================================================

SUBROUTINE info_PEM(i_myear_leg,stopPEM,i_myear,n_myear)

!=======================================================================
!
! Purpose: Update the first line of "info_PEM.txt" to count the number of simulated Martian years
!          Write in "info_PEM.txt" the reason why the PEM stopped and the number of simulated years
!
! Author: RV, JBC
!=======================================================================

use time_evol_mod, only: convert_years, year_bp_ini

implicit none

!----- Arguments
integer, intent(in) :: stopPEM          ! Reason to stop
real,    intent(in) :: i_myear_leg      ! # of years
real,    intent(in) :: i_myear, n_myear ! Current simulated Martian year and maximum number of Martian years to be simulated

!----- Local variables
logical       :: ok
integer       :: cstat
character(20) :: fch1, fch2, fch3

!----- Code
inquire(file = 'info_PEM.txt',exist = ok)
if (ok) then
    write(fch1,'(f'//int2str(nb_digits(i_myear) + 5)//'.4)') i_myear
    write(fch2,'(f'//int2str(nb_digits(n_myear) + 5)//'.4)') n_myear
    write(fch3,'(f6.4)') convert_years ! 4 digits to the right of the decimal point to respect the precision of Martian year in "launch_pem.sh"
    call execute_command_line('sed -i "1s/.*/'//trim(fch1)//' '//trim(fch2)//' '//trim(fch3)//' '//int2str(iPCM)//' '//int2str(iPEM + 1)//' '//int2str(nPCM)//' '//int2str(nPCM_ini)//'/" info_PEM.txt',cmdstat = cstat)
    if (cstat > 0) then
        error stop 'info_PEM: command execution failed!'
    else if (cstat < 0) then
        error stop 'info_PEM: command execution not supported!'
    endif
    open(1,file = 'info_PEM.txt',status = "old",position = "append",action = "write")
    ! Martian date, Number of Martians years done by the PEM run, Number of Martians years done by the chainded simulation, Code of the stopping criterion
    ! The conversion ratio from Planetary years to Earth years is given in the header of the file
    write(1,'(f20.4,f20.4,f20.4,i20)') year_bp_ini + i_myear, i_myear_leg, i_myear, stopPEM
    close(1)
else
    error stop 'The file ''info_PEM.txt'' does not exist and cannot be updated!'
endif

END SUBROUTINE info_PEM

!=======================================================================

FUNCTION int2str(i) RESULT(str)
! Function to convert an integer into a string

integer, intent(in)       :: i
character(20)             :: str_tmp
character(:), allocatable :: str

if (nb_digits(real(i)) > len(str_tmp)) error stop 'int2str [info_PEM_mod]: invalid integer for conversion!'
write(str_tmp,'(i0)') i
str = trim(adjustl(str_tmp))

END FUNCTION int2str

!=======================================================================

FUNCTION nb_digits(x) RESULT(idigits)
! Function to give the number of digits for the integer part of a real number

real, intent(in) :: x
integer          :: idigits

idigits = 1
! If x /= 0 then:
if (abs(x) > 1.e-10) idigits = int(log10(abs(x))) + 1

END FUNCTION nb_digits

END MODULE info_PEM_mod
