      SUBROUTINE surfini(ngrid,nq,qsurf,albedo,albedo_bareground,&
                        albedo_snow_SPECTV,albedo_n2_ice_SPECTV)

      USE surfdat_h, only: albedodat
      USE tracer_h, only: igcm_haze
      use planetwide_mod, only: planetwide_maxval, planetwide_minval
      use radinc_h, only : L_NSPECTV
      use callkeys_mod, only : albedosnow, albedon2ice

      IMPLICIT NONE


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!                                                                 !!!!!!!
!!!!!!!   Spectral Albedo Initialisation - Routine modified by MT2015.  !!!!!!!
!!!!!!!                                                                 !!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!--------------------
!   Declarations:
!--------------------

      INTEGER,INTENT(IN) :: ngrid
      INTEGER,INTENT(IN) :: nq
      REAL,INTENT(OUT) :: albedo(ngrid,L_NSPECTV)
      REAL,INTENT(OUT) :: albedo_bareground(ngrid)
      REAL,INTENT(OUT) :: albedo_snow_SPECTV(L_NSPECTV)
      REAL,INTENT(OUT) :: albedo_n2_ice_SPECTV(L_NSPECTV)
      REAL,INTENT(IN) :: qsurf(ngrid,nq) ! tracer on surface (kg/m2)

      INTEGER :: ig,nw
      REAL :: min_albedo,max_albedo

!=======================================================================

      ! Step 1 : Initialisation of the Spectral Albedos.
      DO nw=1,L_NSPECTV
         albedo_snow_SPECTV(nw)=albedosnow
         albedo_n2_ice_SPECTV(nw)=albedon2ice
      ENDDO


      ! Step 2 : We get the bare ground albedo from the start files.
      DO ig=1,ngrid
         albedo_bareground(ig)=0.7 ! albedodat(ig)
	 DO nw=1,L_NSPECTV
	    albedo(ig,nw)=0.7 !albedo_bareground(ig)
	 ENDDO
      ENDDO
      call planetwide_minval(albedo_bareground,min_albedo)
      call planetwide_maxval(albedo_bareground,max_albedo)
      write(*,*) 'surfini: minimum bare ground albedo',min_albedo
      write(*,*) 'surfini: maximum bare ground albedo',max_albedo


      ! Step 3 : We modify the albedo considering some N2 at the surface. We dont take into account water ice (this is made in hydrol after the first timestep) ...
      if (igcm_haze.ne.0) then
         DO ig=1,ngrid
            IF (qsurf(ig,igcm_haze) .GT. 1.) THEN ! This was changed by MT2015. Condition for ~1mm of N2 ice deposit.
	       DO nw=1,L_NSPECTV
	          albedo(ig,nw)=albedo_n2_ice_SPECTV(nw)
	       ENDDO
            END IF
         ENDDO
      else
         write(*,*) "surfini: No N2 ice tracer on surface  ..."
         write(*,*) "         and therefore no albedo change."
      endif
      call planetwide_minval(albedo,min_albedo)
      call planetwide_maxval(albedo,max_albedo)
      write(*,*) 'surfini: minimum corrected initial albedo',min_albedo
      write(*,*) 'surfini: maximum corrected initial albedo',max_albedo


      END
