      SUBROUTINE orbitetriton(pls,pzday,pdist_sol,pdecli)

      use planete_mod, only: p_elips, e_elips, timeperi, obliquit
      use comcstfi_mod, only: pi
      use time_phylmdz_mod, only: daysec
      IMPLICIT NONE

c=======================================================================
c
c   Objet:
c   ------
c
c   Distance from sun and declination as a function of the solar
c   longitude Ls and pday
c
c   Input:
c   ------
c   pls          Ls
c   pzday
c
c   Output:
c   -------
c   pdist_sol     Distance Sun-Planet in UA
c   pdecli        declinaison ( en radians )
c
c=======================================================================
c   Declarations:
c   -------------

c arguments:
c ----------

      REAL pzday,pdist_sol,pdecli,pls

c local variables:
c----------------
      REAL AA,BB,CC
      REAL zanneedebut,zan,zalpha0,zalpha1,zbeta0,zbeta1,zint
      REAL zanneereference

c--------------------------------------------------------------------
c Initialisations

      AA=0.429870
      BB=0.370543
      CC=0.0225091
      zalpha0 = 61.52577*pi/180.
      zalpha1 = 0.038142
      zbeta0 = -100.79473*pi/180.
      zbeta1 = 0.009131
      zanneedebut = 0.
      zanneereference =  0.

c Distance Sun-Planet

      pdist_sol=p_elips/(1.+e_elips*cos(pls+timeperi))

c Solar declination

      zan  = zanneedebut+(pzday*daysec/31557595.)-zanneereference
      zint = AA * cos(zalpha0 - zalpha1 * zan)
      zint = zint + BB*sin(zalpha0-zbeta0+(zbeta1-zalpha1)*zan)
      zint = zint + CC*sin(zalpha0+zbeta0-(zalpha1+zbeta1)*zan)
      pdecli = -asin (zint)

      RETURN
      END
