
       module surfdat_h

       implicit none

       real,allocatable,dimension(:) :: albedodat ! albedo of bare ground stocked in startfi.nc file.
!$OMP THREADPRIVATE(albedodat)
       ! Ehouarn: moved inertiedat to comsoil.h
       !      real inertiedat, ! thermal inertia
       real,allocatable,dimension(:) :: phisfi ! geopotential at ground level
!$OMP THREADPRIVATE(phisfi)
       real,dimension(2) :: emisice ! ice emissivity; 1:Northern hemisphere 2:Southern hemisphere
       real emissiv
       real,dimension(2) :: iceradius, dtemisice
!$OMP THREADPRIVATE(emisice,emissiv,iceradius,dtemisice)
       real,allocatable,dimension(:) :: zmea,zstd,zsig,zgam,zthe
!$OMP THREADPRIVATE(zmea,zstd,zsig,zgam,zthe)
       real phitop ! heatflux at top of atmosphere? for Triton !AF24
       real ttop
       real,allocatable,dimension(:) :: kp ! TB ref pressure
       real p00
!$OMP THREADPRIVATE(phitop,ttop,kp,p00)
! surface properties ! TB16
       real alb_n2b,alb_n2a,alb_ch4,alb_co,alb_tho,emis_n2b,emis_n2a
!$OMP THREADPRIVATE(alb_n2b,alb_n2a,alb_ch4,alb_co,alb_tho,emis_n2b,emis_n2a)
       real emis_ch4,emis_co,emis_tho,emis_tho_eq,alb_tho_eq,alb_ch4_eq
!$OMP THREADPRIVATE(emis_ch4,emis_co,emis_tho,emis_tho_eq,alb_tho_eq,alb_ch4_eq)
       real ITN2,ITCH4,ITH2O,ITN2d,ITCH4d,ITH2Od,alb_ch4_s,albspe,emispe
!$OMP THREADPRIVATE(ITN2,ITCH4,ITH2O,ITN2d,ITCH4d,ITH2Od,alb_ch4_s,albspe,emispe)
       real alb_tho_spe,emis_tho_spe
!$OMP THREADPRIVATE(alb_tho_spe,emis_tho_spe)

       real,allocatable,dimension(:) :: dryness  !"Dryness coefficient" for grnd water ice sublimation
                                                 ! AS: previously in tracer.h. it is more logical here.
!$OMP THREADPRIVATE(dryness)

       end module surfdat_h

