# Script to initialize the git repository and link it to the svn.
# The synchronization requires two pushes
# (1st push=svn dcommit, 2nd push=git push)
# WARNING: we assume the svn and the git are up-to-date
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
cd ${SCRIPT_DIR}/..

echo "WARNING: this script will setup the git repo"
echo "or download it in the git-trunk/ folder (and link with git-svn)."

while true; do
    read -p "Do you wish to continue? [y/n] " yn
    case $yn in
        [Yy]* ) break;;
        [Nn]* ) exit;;
        * ) echo "Please answer yes (y) or no (n).";;
    esac
done

URL=git@gitlab.in2p3.fr:la-communaut-des-mod-les-atmosph-riques-plan-taires/git-trunk.git
LOCAL_URL=`git remote get-url origin 2>/dev/null`
if [ "${LOCAL_URL}" !=  "${URL}" ];then
    git clone ${URL}
    cd git-trunk
fi

# link svn to git as git-svn branch
# (need git-svn to work)
git svn init https://svn.lmd.jussieu.fr/Planeto/trunk

git update-ref refs/remotes/git-svn refs/remotes/origin/master
# git svn rebase # not used (we assume we're up-to-date)

# install pre-push hook to ensure
# users push only commits in sync with svn

ln UTIL/pre-push .git/hooks
