         if (.not.callrichsl) then
       
             DO ig=1,ngrid
!! sensible heat flux in W/m2

             sensheat(ig) = zflubid(ig)-capcal(ig)*zdtsdif(ig)

!! u star in similarity theory in m/s
             ustar(ig) = 0.4
     .               * sqrt( pu(ig,1)*pu(ig,1) + pv(ig,1)*pv(ig,1) )
     .               / log( 1.E+0 + zzlay(ig,1)/z0_default )
             ENDDO

         else

            DO ig=1,ngrid

! New SL parametrization, correct formulation for sensheat :

            sensheat(ig) = (pplay(ig,1)/(r*pt(ig,1)))*cpp
     &        *sqrt(pu(ig,1)*pu(ig,1) + pv(ig,1)*pv(ig,1)
     &        + (1.2*wmax_th(ig))**2)
     &        *zcdh(ig)*(tsurf(ig)-zh(ig,1))

! New SL parametrization, ustar is more accurately computed in vdif_cd :
            ustar(ig) = sqrt(zcdv(ig)*
     &   (pu(ig,1)*pu(ig,1) + pv(ig,1)*pv(ig,1) + (0.7*wmax_th(ig))**2)
     &                     )

            ENDDO   

         endif  !of if callrichsl

!         write (*,*) 'PHYS HFX cp zdts', sensheat(100), zflubid(100), 
!     .       capcal(100), 
!     .       zdtsdif(100)
!         write (*,*) 'PHYS UST', ustar(100) 

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! LES LES 
       IF (flag_LES) THEN        

         write (*,*) '************************************************' 
         write (*,*) '** LES mode: the difv part is only used to'
         write (*,*) '**  provide HFX and UST to the dynamics'
         write (*,*) '** NB: - dudif, dvdif, dhdif, dqdif are set to 0'
         write (*,*) '**     - tsurf is updated'     
         write (*,*) '************************************************'

         DO ig=1,ngrid
          wmax_th(ig)=0.  !! no additional gustiness needed in surface layer (see vdifc.F)
          DO l=1,nlayer
            zdvdif(ig,l) = 0.
            zdudif(ig,l) = 0.
            zdhdif(ig,l) = 0.
            DO iq=1, nq
              zdqdif(ig,l,iq) = 0.
              zdqsdif(ig,iq) = 0. !! sortir de la boucle
            ENDDO 
          ENDDO
         ENDDO
      ENDIF
!!! LES LES        
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
