#!/bin/bash
# script to download and install the latest version of IOIPSL on ADASTRA with gnu compilers
#

#0. Preliminary stuff 

if (( $# == 0 ))
then
  # default behavior: get latest version of IOIPSL
  rev="HEAD"
else
  # but otherwise the first argument of the script can be the version to use
  if (( $# == 1 ))
  then
    rev=$1
  else
    echo "Error, invalid script arguments"
    echo "Usage:"
    echo "$0 rev"
    echo " where optional rev is the IOIPSL revision number"
    exit
  fi
fi

# cleanup possible previous attempt:
\rm -rf ../../IOIPSL modipsl 

# 1. Get IOIPSL 
# move up at same level as LMDZ.COMMON , etc.
cd ../..
svn co --username icmc_users --password icmc2022 --non-interactive --revision $rev http://forge.ipsl.jussieu.fr/igcmg/svn/IOIPSL/trunk IOIPSL

# 2. Set correct settings: copy over arch.* files
cd IOIPSL
cp -f ../LMDZ.COMMON/arch/arch-MESU-gnu.env arch
cp -f ../LMDZ.COMMON/arch/arch-MESU-gnu.path arch
cp -f ../LMDZ.COMMON/arch/arch-MESU-gnu.fcm arch

# 2.1 Switch ksh to bash in IOIPSL
sed -i -e s:'/bin/ksh':"/bin/bash":1 ins_m_prec

## 3. build ioipsl:
./makeioipsl_fcm -arch MESU-gnu -job 8 > makeioipsl.out 2>&1

## 4. Check if the library was indeed built:
whereami=`pwd -P`
if [[ -f lib/libioipsl.a ]] 
  then
  echo "OK: ioipsl library is in ${whereami}/lib"
else
  echo "Something went wrong... check messages in ${whereami}/makeioipsl.out"
  exit
fi

