      SUBROUTINE inifis(ngrid,nlayer,
     $           day_ini,pdaysec,ptimestep,
     $           plat,plon,parea,
     $           prad,pg,pr,pcpp)
!
!=======================================================================
!
!   purpose:
!   -------
!
!   Initialisation for the physical parametrisations of the LMD 
!   Pluto atmospheric general circulation modele.
!   used by 1D Model only
!
!   author: Frederic Hourdin 15 / 10 /93
!   -------
!   modified: Sebastien Lebonnois 11/06/2003 (new callphys.def)
!             Ehouarn Millour (oct. 2008) tracers are now identified
!              by their names and may not be contiguously
!              stored in the q(:,:,:,:) array
!             E.M. (june 2009) use getin routine to load parameters
!
!
!   arguments:
!   ----------
!
!   input:
!   ------
!
!    ngrid                 Size of the horizontal grid.
!                          All internal loops are performed on that grid.
!    nlayer                Number of vertical layers.
!    pdayref               Day of reference for the simulation
!    pday                  Number of days counted from the North. Spring
!                          equinoxe.
!
!=======================================================================
!
!-----------------------------------------------------------------------
!   declarations:
!   -------------
! to use  'getin'
      USE ioipsl_getincom 
      use planet_h         
      use comgeomfi_h 
      use datafile_mod
      IMPLICIT NONE
#include "dimensions.h"
#include "dimphys.h"
!#include "planete.h"
#include "comcstfi.h"
#include "comsaison.h"
#include "comdiurn.h"
#include "callkeys.h"
#include "surfdat.h"


      REAL prad,pg,pr,pcpp,pdaysec,ptimestep
 
      INTEGER ngrid,nlayer
      REAL plat(ngrid),plon(ngrid),parea(ngridmx)
      integer day_ini
      INTEGER ig,ierr
 
      EXTERNAL iniorbit,orbite
      EXTERNAL SSUM
      REAL SSUM
 
      CHARACTER ch1*12
      CHARACTER ch80*80

      logical chem, h2o
      logical :: parameter, doubleq=.false.

      rad=prad
      daysec=pdaysec
      dtphys=ptimestep
      cpp=pcpp
      g=pg
      r=pr
      rcp=r/cpp


      avocado = 6.02214179e23   ! added by RW


! --------------------------------------------------------
!     The usual Tests
!     --------------
      IF (nlayer.NE.nlayermx) THEN
         PRINT*,'STOP in inifis'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'nlayer     = ',nlayer
         PRINT*,'nlayermx   = ',nlayermx
         STOP
      ENDIF

      IF (ngrid.NE.ngridmx) THEN
         PRINT*,'STOP in inifis'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'ngrid     = ',ngrid
         PRINT*,'ngridmx   = ',ngridmx
         STOP
      ENDIF

! --------------------------------------------------------------
!  Reading the "callphys.def" file controlling some key options
! --------------------------------------------------------------
     
      ! check that 'callphys.def' file is around
      OPEN(99,file='callphys.def',status='old',form='formatted'
     &     ,iostat=ierr)
      CLOSE(99)
      
      IF(ierr.EQ.0) THEN
         PRINT*
         PRINT*
         PRINT*,'--------------------------------------------'
         PRINT*,' inifis: Parametres pour la physique (callphys.def)'
         PRINT*,'--------------------------------------------'

!***************************************************************
         !! Directories / Files

         write(*,*) "Directory where external input files are:"
         datadir="../../../datagcm"  ! default path
         call getin("datadir",datadir) 
         write(*,*) " datafile = ",trim(datadir)

         write(*,*) "Haze optical properties datafile"
         hazeprop="../../../datagcm"  ! default path
         call getin("hazeprop",hazeprop) 
         write(*,*) " hazeprop = ",trim(hazeprop)
         write(*,*) "Haze radii datafile"
         hazerad_file="hazerad.txt"  ! default file
         call getin("hazerad_file",hazerad_file)
         write(*,*) " hazerad_file = ",trim(hazerad_file)
         write(*,*) "Haze mmr datafile"
         hazemmr_file="None"  ! default file
         call getin("hazemmr_file",hazemmr_file)
         write(*,*) " hazemmr_file = ",trim(hazemmr_file)
         write(*,*) "Haze dens datafile"
         hazedens_file="None"  ! default file
         call getin("hazedens_file",hazedens_file)
         write(*,*) " hazedens_file = ",trim(hazedens_file)

!***************************************************************
         !! Basics

         write(*,*) "Run with or without tracer transport ?"
         tracer=.false. ! default value
         call getin("tracer",tracer)
         write(*,*) " tracer = ",tracer

         write(*,*) "Diurnal cycle ?"
         write(*,*) "(if diurnal=false, diurnal averaged solar heating)"
         diurnal=.true. ! default value
         call getin("diurnal",diurnal)
         write(*,*) " diurnal = ",diurnal

         write(*,*) "Seasonal cycle ?"
         write(*,*) "(if season=false, Ls stays constant, to value ",
     &   "set in 'start'"
         season=.true. ! default value
         call getin("season",season)
         write(*,*) " season = ",season

         write(*,*) "Run 1D or 3D version (false) / fast version 
     &          volatile transport (true) ?"
         fast=.false. ! default value
         call getin("fast",fast)
         write(*,*) " fast = ",fast

         write(*,*) "1D options:"
         globmean1d=.false. ! default value
         call getin("globmean1d",globmean1d)
         write(*,*) " globmean1d = ",globmean1d
         kmixmin=1 ! default value
         call getin("kmixmin",kmixmin)
         write(*,*) " kmixmin = ",kmixmin
         kmix_proffix=.false. ! default value
         call getin("kmix_proffix",kmix_proffix)
         write(*,*) " kmix_proffix = ",kmix_proffix

         write(*,*) "Write some extra output to the screen ?"
         lwrite=.false. ! default value
         call getin("lwrite",lwrite)
         write(*,*) " lwrite = ",lwrite

         write(*,*) "Save statistics in file stats.nc ?"
         callstats=.true. ! default value
         call getin("callstats",callstats)
         write(*,*) " callstats = ",callstats

         write(*,*) "Test energy conservation of model physics ?"
         enertest=.false. ! default value
         call getin("enertest",enertest)
         write(*,*) " enertest = ",enertest
         conservn2=.false. ! default value
         call getin("conservn2",conservn2)
         write(*,*) " conservn2 = ",conservn2

         write(*,*) "Run with Triton orbit ?"
         triton=.false. ! default value
         call getin("triton",triton)
         write(*,*) " triton = ",triton
         convergeps=.false. ! default value
         call getin("convergeps",convergeps)
         write(*,*) " convergeps = ",convergeps

         write(*,*) "KBO runs (eris, makemake) ?"
         kbo=.false. ! default value
         call getin("kbo",kbo)
         write(*,*) " kbo = ",kbo

         write(*,*) "Specific paleo run ?"
         paleo=.false. ! default value
         call getin("paleo",paleo)
         write(*,*) " paleo = ",paleo

         write(*,*) "paleoclimate step (Earth years) "
         paleoyears=10000. ! default value
         call getin("paleoyears",paleoyears)
         write(*,*) " paleoyears = ",paleoyears

!***************************************************************
         !! Radiative transfer options

         write(*,*) "call radiative transfer ?"
         callrad=.true. ! default value
         call getin("callrad",callrad)
         write(*,*) " callrad = ",callrad

         write(*,*)"rad.transfer is computed every iradia",
     &             " physical timestep"
         iradia=1 ! default value
         call getin("iradia",iradia)
         write(*,*)" iradia = ",iradia

         write(*,*) "call correlated-k radiative transfer ?"
         corrk=.true. ! default value
         call getin("corrk",corrk)
         write(*,*) " corrk = ",corrk

         write(*,*) "call specific cooling for radiative transfer ?"
         cooling=.false. ! default value
         call getin("cooling",cooling)
         write(*,*) " cooling = ",cooling

         write(*,*) "fixed gaseous CH4 mixing ratio for rad transfer ?"
         ch4fix=.false. ! default value
         call getin("ch4fix",ch4fix)
         write(*,*) " ch4fix = ",ch4fix
         write(*,*) "fixed gaseous CH4 mixing ratio for rad transfer ?"
         vmrch4fix=0.5 ! default value
         call getin("vmrch4fix",vmrch4fix)
         write(*,*) " vmrch4fix = ",vmrch4fix
         vmrch4_proffix=.false. ! default value
         call getin("vmrch4_proffix",vmrch4_proffix)
         write(*,*) " vmrch4_proffix = ",vmrch4_proffix

         write(*,*) "NLTE correction for methane heating rates?"
         nlte=.false.  ! default value
         call getin("nlte",nlte)
         write(*,*) " nlte = ",nlte
         strobel=.false.  ! default value
         call getin("strobel",strobel)
         write(*,*) " strobel = ",strobel

         write(*,*) "call gaseous absorption in the visible bands?"
         callgasvis=.false. ! default value
         call getin("callgasvis",callgasvis)
         write(*,*) " callgasvis = ",callgasvis

         write(*,*)"Output mean OLR in 1D?"
         meanOLR=.false.
         call getin("meanOLR",meanOLR)
         write(*,*)" meanOLR = ",meanOLR

         write(*,*)"Output spectral OLR in 3D?"
         specOLR=.false.
         call getin("specOLR",specOLR)
         write(*,*)" specOLR = ",specOLR

!***************************************************************
         !! From generic model - to be cleaned

         write(*,*)"Which star?"
         startype=1 ! default value = Sol
         call getin("startype",startype)
         write(*,*)" startype = ",startype
         write(*,*)"Value of stellar flux at 1 AU?"
         Fat1AU=1366.0 ! default value = Sol today
         call getin("Fat1AU",Fat1AU)
         write(*,*)" Fat1AU = ",Fat1AU
         write(*,*)"Default planetary temperature?"
         tplanet=100.0
         call getin("tplanet",tplanet)
         write(*,*)" tplanet = ",tplanet

!***************************************************************
         !! TRACERS options

         write(*,*) "call N2 condensation ?"
         N2cond=.true. ! default value
         call getin("N2cond",N2cond)
         write(*,*) " N2cond = ",N2cond

         write(*,*) "call N2 cloud condensation ?"
         condensn2=.false. ! default value
         call getin("condensn2",condensn2)
         write(*,*) "condensn2 = ",condensn2

         write(*,*) "call no N2 frost formation?"
         no_n2frost=.false. ! default value
         call getin("no_n2frost",no_n2frost)
         write(*,*) "no_n2frost = ",no_n2frost

         write(*,*) "N2 condensation subtimestep?"
         nbsub=20 ! default value
         call getin("nbsub",nbsub)
         write(*,*) " nbsub = ",nbsub

         write(*,*) "Gravitationnal sedimentation ?"
         sedimentation=.true. ! default value
         call getin("sedimentation",sedimentation)
         write(*,*) " sedimentation = ",sedimentation

         write(*,*) "Compute glacial flow ?"
         glaflow=.false. ! default value
         call getin("glaflow",glaflow)
         write(*,*) " glaflow = ",glaflow

         write(*,*) "Compute methane cycle ?"
         methane=.false. ! default value
         call getin("methane",methane)
         write(*,*) " methane = ",methane
         condmetsurf=.true. ! default value
         call getin("condmetsurf",condmetsurf)
         write(*,*) " condmetsurf = ",condmetsurf

         write(*,*) "Compute methane clouds ?"
         metcloud=.false. ! default value
         call getin("metcloud",metcloud)
         write(*,*) " metcloud = ",metcloud

         write(*,*) "Compute CO cycle ?"
         carbox=.false. ! default value
         call getin("carbox",carbox)
         write(*,*) " carbox = ",carbox
         condcosurf=.true. ! default value
         call getin("condcosurf",condcosurf)
         write(*,*) " condcosurf = ",condcosurf

         write(*,*) "Compute CO clouds ?"
         monoxcloud=.false. ! default value
         call getin("monoxcloud",monoxcloud)
         write(*,*) " monoxcloud = ",monoxcloud

         write(*,*)"atmospheric redistribution (s):"
         tau_n2=1. ! default value
         call getin("tau_n2",tau_n2)
         write(*,*)" tau_n2 = ",tau_n2
         tau_ch4=1.E7 ! default value
         call getin("tau_ch4",tau_ch4)
         write(*,*)" tau_ch4 = ",tau_ch4
         tau_co=1. ! default value
         call getin("tau_co",tau_co)
         write(*,*)" tau_co = ",tau_co
         tau_prechaze=1. ! default value
         call getin("tau_prechaze",tau_prechaze)
         write(*,*)" tau_prechaze = ",tau_prechaze

         write(*,*) "Day fraction for limited cold trap in SP?"
         dayfrac=0. ! default value
         call getin("dayfrac",dayfrac)
         write(*,*) " dayfrac = ",dayfrac
         thresh_non2=0. ! default value
         call getin("thresh_non2",thresh_non2)
         write(*,*) " thresh_non2 = ",thresh_non2

!***************************************************************
         !! Haze options

         write(*,*)"Production of haze ?"
         haze=.false. ! default value
         call getin("haze",haze)
         write(*,*)" haze = ",haze
         hazeconservch4=.false. ! conservch4, by default value ch4 is photolyzed
         call getin("hazeconservch4",hazeconservch4)
         write(*,*)"hazconservch4 = ",hazeconservch4
         write(*,*)"Production of haze (fast version) ?"
         fasthaze=.false. ! default value
         call getin("fasthaze",fasthaze)
         write(*,*)"fasthaze = ",fasthaze

         write(*,*)"Add source of haze ?"
         source_haze=.false. ! default value
         call getin("source_haze",source_haze)
         write(*,*)" source_haze = ",source_haze
         mode_hs=0 ! mode haze source default value
         call getin("mode_hs",mode_hs)
         write(*,*)" mode_hs",mode_hs
         kfix=1 ! default value
         call getin("kfix",kfix)
         write(*,*)"levels kfix",kfix
         fracsource=0.1 ! default value
         call getin("fracsource",fracsource)
         write(*,*)" fracsource",fracsource
         latsource=30. ! default value
         call getin("latsource",latsource)
         write(*,*)" latsource",latsource
         lonsource=180. ! default value
         call getin("lonsource",lonsource)
         write(*,*)" lonsource",lonsource

         write(*,*)"Radiatively active haze ?"
         aerohaze=.false. ! default value
         call getin("aerohaze",aerohaze)
         write(*,*)"aerohaze = ",aerohaze

         write(*,*)"Haze monomer radius ?"
         rad_haze=10.e-9 ! default value
         call getin("rad_haze",rad_haze)
         write(*,*)"rad_haze = ",rad_haze

         write(*,*)"fractal particle ?"
         fractal=.false. ! default value
         call getin("fractal",fractal)
         write(*,*)"fractal = ",fractal
         nb_monomer=10 ! default value
         call getin("nb_monomer",nb_monomer)
         write(*,*)"nb_monomer = ",nb_monomer
         
         write(*,*)"fixed radius profile from txt file ?"
         haze_radproffix=.false. ! default value
         call getin("haze_radproffix",haze_radproffix)
         write(*,*)"haze_radproffix = ",haze_radproffix
         write(*,*)"fixed MMR profile from txt file ?"
         haze_proffix=.false. ! default value
         call getin("haze_proffix",haze_proffix)
         write(*,*)"haze_proffix = ",haze_proffix

         write(*,*)"Number mix ratio of haze particles for co clouds:"
         Nmix_co=100000. ! default value
         call getin("Nmix_co",Nmix_co)
         write(*,*)" Nmix_co = ",Nmix_co

         write(*,*)"Number mix ratio of haze particles for ch4 clouds:"
         Nmix_ch4=100000. ! default value
         call getin("Nmix_ch4",Nmix_ch4)
         write(*,*)" Nmix_ch4 = ",Nmix_ch4

!***************************************************************
         !! Surface properties

!*********** N2 *********************************

         write(*,*) "Mode for changing N2 albedo"
         mode_n2=0 ! default value
         call getin("mode_n2",mode_n2)
         write(*,*) " mode_n2 = ",mode_n2
         thres_n2ice=1. ! default value
         call getin("thres_n2ice",thres_n2ice)
         write(*,*) " thres_n2ice = ",thres_n2ice

         write(*,*) "Diff of N2 albedo with thickness"
         deltab=0. ! default value
         call getin("deltab",deltab)
         write(*,*) " deltab = ",deltab

         write(*,*) "albedo N2 beta "
         alb_n2b=0.7 ! default value
         call getin("alb_n2b",alb_n2b)
         write(*,*) " alb_n2b = ",alb_n2b

         write(*,*) "albedo N2 alpha "
         alb_n2a=0.7 ! default value
         call getin("alb_n2a",alb_n2a)
         write(*,*) " alb_n2a = ",alb_n2a

         write(*,*) "emis N2 beta "
         emis_n2b=0.7 ! default value
         call getin("emis_n2b",emis_n2b)
         write(*,*) " emis_n2b = ",emis_n2b

         write(*,*) "emis N2 alpha "
         emis_n2a=0.7 ! default value
         call getin("emis_n2a",emis_n2a)
         write(*,*) " emis_n2a = ",emis_n2a

!*********** CH4 *********************************

         write(*,*) "Mode for changing CH4 albedo"
         mode_ch4=0 ! default value
         call getin("mode_ch4",mode_ch4)
         write(*,*) " mode_ch4 = ",mode_ch4
         feedback_met=0 ! default value
         call getin("feedback_met",feedback_met)
         write(*,*) " feedback_met = ",feedback_met
         thres_ch4ice=1. ! default value, mm
         call getin("thres_ch4ice",thres_ch4ice)
         write(*,*) " thres_ch4ice = ",thres_ch4ice
         fdch4_latn=-1. 
         fdch4_lats=0. 
         fdch4_lone=0. 
         fdch4_lonw=-1. 
         fdch4_depalb=0.5 
         fdch4_finalb=0.95 
         fdch4_maxalb=0.99 
         fdch4_ampl=200. 
         fdch4_maxice=100. 
         call getin("  fdch4_latn",fdch4_latn)
         call getin("  fdch4_lats",fdch4_lats)
         call getin("  fdch4_lone",fdch4_lone)
         call getin("  fdch4_lonw",fdch4_lonw)
         call getin("  fdch4_depalb",fdch4_depalb)
         call getin("  fdch4_finalb",fdch4_finalb)
         call getin("  fdch4_maxalb",fdch4_maxalb)
         call getin("  fdch4_maxice",fdch4_maxice)
         call getin("  fdch4_ampl",fdch4_ampl)
         write(*,*) " Values for albedo feedback = ",fdch4_latn,
     &    fdch4_lats,fdch4_lone,fdch4_lonw,fdch4_depalb,
     &    fdch4_finalb,fdch4_maxalb,fdch4_maxice,fdch4_ampl

         write(*,*) "Latitude for diff albedo methane"
         metlateq=25. ! default value
         call getin("metlateq",metlateq)
         write(*,*) " metlateq = ",metlateq

         write(*,*) "Ls1 and Ls2 for change of ch4 albedo"
         metls1=-1. ! default value
         metls2=-2. ! default value
         call getin("metls1",metls1)
         call getin("metls2",metls2)

         write(*,*) "albedo CH4 "
         alb_ch4=0.5 ! default value
         call getin("alb_ch4",alb_ch4)
         write(*,*) " alb_ch4 = ",alb_ch4

         write(*,*) "albedo equatorial CH4 "
         alb_ch4_eq=alb_ch4 ! default value
         call getin("alb_ch4_eq",alb_ch4_eq)
         write(*,*) " alb_ch4_eq = ",alb_ch4_eq

         write(*,*) "albedo south hemis CH4 "
         alb_ch4_s=alb_ch4 ! default value
         call getin("alb_ch4_s",alb_ch4_s)
         write(*,*) " alb_ch4_s = ",alb_ch4_s

         write(*,*) "emis CH4 "
         emis_ch4=0.5 ! default value
         call getin("emis_ch4",emis_ch4)
         write(*,*) " emis_ch4 = ",emis_ch4

         write(*,*) "CH4 lag for n2 sublimation limitation"
         ch4lag=.false. ! default value
         latlag=-90. ! default value
         vmrlag=1. ! default value
         call getin("ch4lag",ch4lag)
         call getin("latlag",latlag)
         call getin("vmrlag",vmrlag)
         write(*,*) " ch4lag = ",ch4lag
         write(*,*) " latlag = ",latlag
         write(*,*) " vmrlag = ",vmrlag

         write(*,*) "Max temperature for surface ?"
         tsurfmax=.false. ! default value
         albmin_ch4=0.3 ! default value
         call getin("tsurfmax",tsurfmax)
         call getin("albmin_ch4",albmin_ch4)
         write(*,*) " tsurfmax = ",tsurfmax
         write(*,*) " albmin_ch4 = ",albmin_ch4

!*********** CO *********************************

         write(*,*) "albedo CO "
         alb_co=0.4 ! default value
         call getin("alb_co",alb_co)
         write(*,*) " alb_co = ",alb_co
         thres_coice=1. ! default value, mm
         call getin("thres_coice",thres_coice)
         write(*,*) " thres_coice = ",thres_coice

         write(*,*) "emis CO "
         emis_co=0.4 ! default value
         call getin("emis_co",emis_co)
         write(*,*) " emis_co = ",emis_co

!*********** THOLINS *********************************
         write(*,*) "Mode for changing tholins albedo/emis"
         mode_tholins=0 ! default value
         call getin("mode_tholins",mode_tholins)
         write(*,*) " mode_tholins = ",mode_tholins

         write(*,*) "albedo tho "
         alb_tho=0.1 ! default value
         call getin("alb_tho",alb_tho)
         write(*,*) " alb_tho = ",alb_tho

         write(*,*) "albedo tho eq"
         alb_tho_eq=0.1 ! default value
         call getin("alb_tho_eq",alb_tho_eq)
         write(*,*) " alb_tho_eq = ",alb_tho_eq

         write(*,*) "emis tholins "
         emis_tho=1. ! default value
         call getin("emis_tho",emis_tho)
         write(*,*) " emis_tho = ",emis_tho

         write(*,*) "emis tholins eq"
         emis_tho_eq=1. ! default value
         call getin("emis_tho_eq",emis_tho_eq)
         write(*,*) " emis_tho_eq = ",emis_tho_eq

         write(*,*) "Latitude for diff albedo tholins"
         tholateq=25. ! default value
         call getin("tholateq",tholateq)
         write(*,*) " tholateq = ",tholateq
         tholatn=-1. 
         tholats=0. 
         tholone=0. 
         tholonw=-1. 
         alb_tho_spe=0.1 ! default value
         emis_tho_spe=1. ! default value
         call getin("  tholatn",tholatn)
         call getin("  tholats",tholats)
         call getin("  tholone",tholone)
         call getin("  tholonw",tholonw)
         write(*,*) " Values for special tholins albedo = ",tholatn,
     &       tholats,tholone,tholonw,alb_tho_spe,emis_tho_spe

         write(*,*) "Specific albedo"
         spelon1=-180. ! default value
         spelon2=180. ! default value
         spelat1=-90. ! default value
         spelat2=90. ! default value
         specalb=.false. ! default value
         write(*,*) "albedo/emis spe "
         albspe=0.1 ! default value
         emispe=1. ! default value
         call getin("spelon1",spelon1)
         call getin("spelon2",spelon2)
         call getin("spelat1",spelat1)
         call getin("spelat2",spelat2)
         call getin("specalb",specalb)
         call getin("albspe",albspe)
         call getin("emispe",emispe)

         write(*,*) " specific = ",specalb

!********************** TI *****************************

         write(*,*) "Change TI with time"
         changeti=.false. ! default value
         call getin("changeti",changeti)
         write(*,*) " changeti = ",changeti
         changetid=.false. ! default value for diurnal TI
         call getin("changetid",changetid)
         write(*,*) " changetid = ",changetid

         write(*,*) "IT N2 "
         ITN2=800. ! default value
         call getin("ITN2",ITN2)
         write(*,*) " ITN2 = ",ITN2
         ITN2d=20. ! default value
         call getin("ITN2d",ITN2d)
         write(*,*) " ITN2d = ",ITN2d

         write(*,*) "IT CH4"
         ITCH4=800. ! default value
         call getin("ITCH4",ITCH4)
         write(*,*) " ITCH4 = ",ITCH4
         ITCH4d=20. ! default value
         call getin("ITCH4d",ITCH4d)
         write(*,*) " ITCH4d = ",ITCH4d

         write(*,*) "IT H2O"
         ITH2O=800. ! default value
         call getin("ITH2O",ITH2O)
         write(*,*) " ITH2O = ",ITH2O
         ITH2Od=20. ! default value
         call getin("ITH2Od",ITH2Od)
         write(*,*) " ITH2Od = ",ITH2Od

!***************************************************************
         !! Other Physics Options

         write(*,*)"Geothermal flux (W) at the bottom layer"
         fluxgeo=0. ! default value
         call getin("fluxgeo",fluxgeo)
         write(*,*)" fluxgeo = ",fluxgeo

         write(*,*)"Assymetry flux (W) at the bottom layer"
         assymflux=.false. ! default value
         call getin("assymflux",assymflux)
         write(*,*)" assymflux = ",assymflux
         write(*,*)"Geothermal flux (W) for assymetry"
         fluxgeo2=fluxgeo ! default value
         call getin("fluxgeo2",fluxgeo2)
         write(*,*)" fluxgeo2 = ",fluxgeo2
         write(*,*)"Warm patch of flux"
         patchflux=0 ! default value
         call getin("patchflux",patchflux)
         write(*,*)" patchflux = ",patchflux
         
         write(*,*) "call turbulent vertical diffusion ?"
         calldifv=.false. ! default value
         call getin("calldifv",calldifv)
         write(*,*) " calldifv = ",calldifv
         vertdiff=.true. ! default value
         call getin("vertdiff",vertdiff)
         write(*,*) " vertdiff = ",vertdiff

         write(*,*) "call convective adjustment ?"
         calladj=.false. ! default value
         call getin("calladj",calladj)
         write(*,*) " calladj = ",calladj
        
         write(*,*)"call thermal conduction in the soil ?"
         callsoil=.true. ! default value
         call getin("callsoil",callsoil)
         write(*,*) " callsoil = ",callsoil
       
         write(*,*) "photochemistry: include chemical species"
         photochem=.false. ! default value
         call getin("photochem",photochem)
         write(*,*) " photochem = ",photochem

         write(*,*) "call thermal conduction ?"
         callconduct=.false. ! default value
         call getin("callconduct",callconduct)
         write(*,*) " callconduct = ",callconduct

         write(*,*) "call phitop ?"
         phitop=0. ! default value
         call getin("phitop",phitop)
         write(*,*) " phitop = ",phitop

         write(*,*) "call molecular viscosity ?"
         callmolvis=.false. ! default value
         call getin("callmolvis",callmolvis)
         write(*,*) " callmolvis = ",callmolvis

         write(*,*) "call molecular diffusion ?"
         callmoldiff=.false. ! default value
         call getin("callmoldiff",callmoldiff)
         write(*,*) " callmoldiff = ",callmoldiff

c         write(*,*) "call thermosphere ?"
c         callthermos=.false. ! default value
c         call getin("callthermos",callthermos)
c         write(*,*) " callthermos = ",callthermos


c        write(*,*) "call EUV heating ?",
c    &   " (only if callthermos=.true.)"
c        calleuv=.false.  ! default value
c        call getin("calleuv",calleuv)
c        write(*,*) " calleuv = ",calleuv
         
c         write(*,*) "call thermospheric photochemistry ?",
c     &   " (only if callthermos=.true.)"
c         thermochem=.false. ! default value
c         call getin("thermochem",thermochem)
c         write(*,*) " thermochem = ",thermochem

c        if (.not.callthermos) then
c           if (callconduct) then
c             print*,'if callconduct is set, callthermos must be true'
c             stop
c           endif        
c          if (calleuv) then
c            print*,'if calleuv is set, callthermos must be true'
c            stop
c          endif         

!*************************************************************
!*************************************************************
!                   Tests of incompatibility:
!*************************************************************
!*************************************************************

         if ((.not.tracer).and.(haze)) then
           print*,'if haze are on, tracers must be on!'
           stop
         endif
         if (callmolvis.and..not.callconduct) then
             print*,'if callmolvis is set, callconduc must be true'
             stop
         endif        
         if (paleo.and..not.fast) then
             print*,'if paleo is set, fast must be true'
             stop
         endif        
         if (fasthaze.and..not.fast) then
             print*,'if fasthaze is set, fast must be true'
             stop
         endif        
         if (fasthaze.and..not.methane) then
             print*,'if fasthaze is set, methane must be true'
             stop
         endif        
         if ((haze.or.fasthaze).and..not.methane) then
             print*,'if haze/fasthaze is set, methane must be true'
             stop
         endif        
         if ((haze_proffix.or.haze_radproffix).and..not.aerohaze) then
             print*,'for now, haze/rad proffix only works w aerohaze=T'
             stop
         endif        
c          if (callmoldiff) then
c            print*,'if callmoldiff is set, callthermos must be true'
c            stop
c          endif          
c          if (thermochem) then
c            print*,'if thermochem is set, callthermos must be true'
c            stop
c          endif          
c       endif

         PRINT*,'--------------------------------------------'
         PRINT*
         PRINT*
      ELSE
         write(*,*)
         write(*,*) 'Cannot read file callphys.def. Is it here ?'
         stop
      ENDIF

8000  FORMAT(t5,a12,l8)
8001  FORMAT(t5,a12,i8)

      PRINT*
      PRINT*,'inifis: daysec',daysec
      PRINT*
      PRINT*,'inifis: The radiative transfer is computed:'
      PRINT*,'           each ',iradia,' physical time-step'
      !PRINT*,'        or each ',iradia*dtphys,' seconds'
      PRINT*

! --------------------------------------------------------------
!  Managing the Longwave radiative transfer
! --------------------------------------------------------------

!     In most cases, the run just use the following values :
!     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      callemis=.true.     
!     ilwd=10*int(daysec/dtphys) ! bug before 22/10/01       
      ilwd=10*int(daysec/dtphys) 
      ilwn=2               
      linear=.true.        
      ncouche=3
      alphan=0.4
      ilwb=2
      semi=0

c$$$!     BUT people working hard on the LW may want to read them in 'radia.def' 
c$$$!     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c$$$
c$$$      OPEN(99,file='radia.def',status='old',form='formatted'
c$$$     .     ,iostat=ierr)
c$$$      IF(ierr.EQ.0) THEN
c$$$         write(*,*) 'inifis: Reading radia.def !!!'
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) callemis
c$$$         WRITE(*,8000) ch1,callemis
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) iradia
c$$$         WRITE(*,8001) ch1,iradia
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) ilwd
c$$$         WRITE(*,8001) ch1,ilwd
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) ilwn
c$$$         WRITE(*,8001) ch1,ilwn
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) linear
c$$$         WRITE(*,8000) ch1,linear
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) ncouche
c$$$         WRITE(*,8001) ch1,ncouche
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) alphan
c$$$         WRITE(*,*) ch1,alphan
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) ilwb
c$$$         WRITE(*,8001) ch1,ilwb
c$$$
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,'(l1)') callg2d
c$$$         WRITE(*,8000) ch1,callg2d
c$$$
c$$$         READ(99,fmt='(a)') ch1
c$$$         READ(99,*) semi
c$$$         WRITE(*,*) ch1,semi
c$$$      end if
c$$$      CLOSE(99)

!-----------------------------------------------------------------------
!     Some more initialization:
!     ------------------------

      CALL SCOPY(ngrid,plon,1,long,1)
      CALL SCOPY(ngrid,plat,1,lati,1)
      CALL SCOPY(ngrid,parea,1,area,1)
      totarea=SSUM(ngridmx,area,1)
      !! Computing realarea
      DO ig=2,ngridmx-1
         realarea(ig)=area(ig)
      ENDDO
      realarea(1)=area(1)*iim
      realarea(ngridmx)=area(ngridmx)*iim

      DO ig=1,ngrid
         sinlat(ig)=sin(plat(ig))
         coslat(ig)=cos(plat(ig))
         sinlon(ig)=sin(plon(ig))
         coslon(ig)=cos(plon(ig))
      ENDDO

      pi=2.*asin(1.) ! NB: pi is a common in comcstfi.h

!     managing the tracers, and tests:
!     -------------------------------

      if(tracer) then

!          when photochem is used, nqchem_min is the rank
!          of the first chemical species

! Ehouarn: nqchem_min is now meaningless and no longer used
!       nqchem_min = 1
       if (photochem .or. callthermos) then
         chem = .true.
       end if

      endif ! of if (tracer)

      RETURN
      END
