MODULE time_phylmdz_mod

    IMPLICIT NONE
    REAL,SAVE    :: dtphys      ! physics time step (s)
!$OMP THREADPRIVATE(dtphys)

    REAL,SAVE    :: daysec     ! length of day (s)
!$OMP THREADPRIVATE(daysec)

    INTEGER,SAVE :: steps_per_sol ! number of physics steps per sol 
!$OMP THREADPRIVATE(steps_per_sol)

    INTEGER,SAVE :: day_ini     ! initial day of the run
!$OMP THREADPRIVATE(day_ini)
    INTEGER,SAVE :: day_end     ! final day of the run
!$OMP THREADPRIVATE(day_end)
    REAL,SAVE :: hour_ini       ! start time (fraction of day) of the run
                                ! 0=<hour_ini<1
!$OMP THREADPRIVATE(hour_ini)

    INTEGER,SAVE :: outputs_per_sol ! for diagfi.nc outputs, number of outputs
                                    ! per sol (set via conf_phys)
!$OMP THREADPRIVATE(outputs_per_sol)

    INTEGER,SAVE :: iphysiq   ! call physics every iphysiq dynamical step
                              ! (set via conf_phys)
!$OMP THREADPRIVATE(iphysiq)
    INTEGER,SAVE :: ecritstart ! write a restart state every ecritstart
                               ! dynamical steps (set via conf_phys)
!$OMP THREADPRIVATE(ecritstart)
CONTAINS

  SUBROUTINE init_time(day_ini_, day_end_, hour_ini_, daysec_, dtphys_)

    IMPLICIT NONE
    INTEGER,INTENT(IN) :: day_ini_
    INTEGER,INTENT(IN) :: day_end_
    REAL,INTENT(IN) :: hour_ini_
    REAL,INTENT(IN) :: daysec_
    REAL,INTENT(IN) :: dtphys_
    
    day_ini=day_ini_
    day_end=day_end_
    hour_ini=hour_ini_
    daysec=daysec_
    dtphys=dtphys_
    
    ! compute number of physics steps per sol
    steps_per_sol=nint(daysec/dtphys)
    
  END SUBROUTINE init_time

END MODULE time_phylmdz_mod      
