MODULE compute_tend_mod

implicit none

!=======================================================================
contains
!=======================================================================

SUBROUTINE compute_tend(ngrid,nslope,min_ice,tendencies_ice)

implicit none

!=======================================================================
!
! Compute the initial tendencies of the ice evolution based on the PCM data
!
!=======================================================================

!   arguments:
!   ----------
!   INPUT
integer,                         intent(in) :: ngrid   ! # of grid points
integer,                         intent(in) :: nslope  ! # of subslopes
real, dimension(ngrid,nslope,2), intent(in) :: min_ice ! Minima of ice at each point for the PCM years

!   OUTPUT
real, dimension(ngrid,nslope), intent(out) :: tendencies_ice ! Difference between the minima = evolution of perennial ice
!=======================================================================
! We compute the difference
tendencies_ice = min_ice(:,:,2) - min_ice(:,:,1)

! If the difference is too small, then there is no evolution
where (abs(tendencies_ice) < 1.e-10) tendencies_ice = 0.

! If the minimum over the last year is 0, then we have no perennial ice
where (abs(min_ice(:,:,2)) < 1.e-10) tendencies_ice = 0.

END SUBROUTINE compute_tend

END MODULE compute_tend_mod
