!==================================================================
module radii_mod
!  module to centralize the radii calculations for aerosols
!==================================================================

contains

!==================================================================
   subroutine haze_reffrad(ngrid,nlayer,reffrad,nueffrad)
!==================================================================
!     Purpose
!     -------
!     Compute the effective radii of haze particles 
!     uniform case 
!
!==================================================================
      use radinc_h, only: naerkind
      use aerosol_mod

      Implicit none
#include "dimensions.h"
#include "dimphys.h"
#include "tracer.h"
!-----------------------------------------------------------------------
!     Arguments
      
      integer,intent(in) :: ngrid
      integer,intent(in) :: nlayer
      integer :: iaer,l,ig

      real, intent(out) :: reffrad(ngrid,nlayer,naerkind)      ! haze particles radii (m)
      real, intent(out) :: nueffrad(ngrid,nlayer,naerkind)     !

      do iaer=1,naerkind
            print*, 'TB22 iaer',iaer,iaero_haze
            if(iaer.eq.iaero_haze)then  
              ! Equivalent sphere radius
              reffrad(1:ngrid,1:nlayer,iaer)=radius(i_haze)*nmono**(1./3.)
              !reffrad(1:ngrid,1:nlayer,iaer) = 2.e-6 ! haze
              nueffrad(1:ngrid,1:nlayer,iaer) = 0.02 ! haze
              print*, 'TB22 Hello2',radius(i_haze)*nmono**(1./3.)
            endif
      enddo

   end subroutine haze_reffrad
!==================================================================

!==================================================================
   subroutine haze_reffrad_fix(ngrid,nlayer,zzlay,reffrad,nueffrad)
!==================================================================
!     Purpose
!     -------
!     Compute the effective radii of haze particles 
!     fixed profile of radius
!
!==================================================================
      use radinc_h, only: naerkind
      use aerosol_mod
      use datafile_mod    

      Implicit none
#include "dimensions.h"
#include "dimphys.h"
#include "tracer.h"
!-----------------------------------------------------------------------
!     Arguments
      
      integer,intent(in) :: ngrid
      integer,intent(in) :: nlayer
      real,intent(in) :: zzlay(ngrid,nlayer)
      real, intent(out) :: reffrad(ngrid,nlayer,naerkind)      ! haze particles radii (m)
      real, intent(out) :: nueffrad(ngrid,nlayer,naerkind)     !

!     Local variables
      integer :: iaer,l,ifine,ig
      real :: radvec(ngrid,nlayer)

      LOGICAL firstcall
      SAVE firstcall
      DATA firstcall/.true./

      !!read altitudes and radius
      integer Nfine
      !parameter(Nfine=21)
      parameter(Nfine=701)
      character(len=100) :: file_path
      real,save :: levdat(Nfine),raddat(Nfine)

!---------------- INPUT ------------------------------------------------
      
      IF (firstcall) then
        firstcall=.false.
        file_path=trim(datadir)//'/haze_prop/rad_haze.txt'
      !   file_path=trim(datadir)//'/haze_prop/hazerad.txt'
        open(223,file=file_path,form='formatted')
        do ifine=1,Nfine
           read(223,*) levdat(ifine), raddat(ifine)
        enddo
        close(223)
        print*, 'AF24 READ HAZERAD ', file_path
      ENDIF

      ! in radii mod levs has been put in km
      DO ig=1,ngrid
        CALL interp_line(levdat,raddat,Nfine,zzlay(ig,:)/1000,radvec(ig,:),nlayer)
      enddo

      do iaer=1,naerkind
            if(iaer.eq.iaero_haze)then  
                 ! spherical radius or eq spherical radius
                 ! TB22: fractal has no impact on reffrad if haze_radproffix
                 do ig=1,ngrid
                    do l=1,nlayer
                       reffrad(ig,l,iaer)=radvec(ig,l)*1.e-9    !  nm => m 
                    enddo
                 enddo
                 nueffrad(1:ngrid,1:nlayer,iaer) = 0.02 ! haze
            endif
      enddo

   end subroutine haze_reffrad_fix
!==================================================================

end module radii_mod
!==================================================================
