MODULE abort_pem_mod

implicit none

!=======================================================================
contains
!=======================================================================

SUBROUTINE abort_pem(modname,message,ierr)

#ifdef CPP_IOIPSL
    use IOIPSL
#else
    ! if not using IOIPSL, we still need to use (a local version of) getin_dump
    use ioipsl_getincom
#endif

#ifdef CPP_XIOS
    use wxios ! ug Pour les sorties XIOS
#endif

implicit none

#include "iniprint.h"

! Stop the simulation cleanly, closing files and printing various comments
! Input: modname = name of calling program
!        message = stuff to print
!        ierr    = severity of situation (= 0 normal)
character(len = *), intent(in) :: modname
integer,            intent(in) :: ierr
character(len = *), intent(in) :: message

!----- Code
write(lunout,*) 'in abort_pem'

#ifdef CPP_XIOS
    CALL wxios_close() ! Fermeture propre de XIOS
#endif

#ifdef CPP_IOIPSL
    call histclo
    call restclo
#endif

call getin_dump
write(lunout,*) 'Stopping in ', modname
write(lunout,*) 'Reason = ', message
if (ierr == 0) then
    write(lunout,*) 'Everything is cool!'
    stop
else
    write(lunout,*) 'Houston, we have a problem, ierr =', ierr
    stop 1
endif

END SUBROUTINE abort_pem

END MODULE abort_pem_mod
