MODULE info_PEM_mod

implicit none

integer :: iPCM, iPEM, nPCM, nPCM_ini ! Data about the chained simulation of PCM/PEM runs

!=======================================================================
contains
!=======================================================================

SUBROUTINE info_PEM(year_iter,stopPEM,i_myear,n_myear)

!=======================================================================
!
! Purpose: Update the first line of "info_PEM.txt" to count the number of simulated Martian years
!          Write in "info_PEM.txt" the reason why the PEM stopped and the number of simulated years
!
! Author: RV, JBC
!=======================================================================

use time_evol_mod, only: convert_years, year_bp_ini

implicit none

!----- Arguments
integer, intent(in) :: year_iter, stopPEM ! # of year and reason to stop
integer, intent(in) :: i_myear, n_myear          ! Current simulated Martian year and maximum number of Martian years to be simulated

!----- Local variables
logical       :: ok
integer       :: cstat
character(10) :: ich1, ich2, ich3, ich4, ich5, ich6, fch

!----- Code
inquire(file = 'info_PEM.txt', exist = ok)
if (ok) then
    write(ich1,'(i0)') i_myear
    write(ich2,'(i0)') n_myear
    write(fch,'(f0.4)') convert_years ! 4 digits to the right of the decimal point to respect the precision of Martian year in "launch_pem.sh"
    write(ich3,'(i0)') iPCM
    write(ich4,'(i0)') iPEM + 1
    write(ich5,'(i0)') nPCM
    write(ich6,'(i0)') nPCM_ini
    call execute_command_line('sed -i "1s/.*/'//trim(ich1)//' '//trim(ich2)//' '//trim(fch)//' '//trim(ich3)//' '//trim(ich4)//' '//trim(ich5)//' '//trim(ich6)//'/" info_PEM.txt',cmdstat = cstat)
    if (cstat > 0) then
        error stop 'info_PEM: command execution failed!'
    else if (cstat < 0) then
        error stop 'info_PEM: command execution not supported!'
    endif
    open(1,file = 'info_PEM.txt',status = "old",position = "append",action = "write")
    ! Martian date, Number of Martians years done by the PEM run, Number of Martians years done by the chainded simulation, Code of the stopping criterion
    ! The conversion ratio from Planetary years to Earth years is given in the header of the file
    write(1,*) year_bp_ini + i_myear, year_iter, i_myear, stopPEM
    close(1)
else
    error stop 'The file ''info_PEM.txt'' does not exist and cannot be updated!'
endif

END SUBROUTINE info_PEM

END MODULE info_PEM_mod
