#!/bin/bash
########################################################################
#### Launching script for a chained simulation of PEM and PCM runs  ####
########################################################################
# This script can take an argument:
#   - If there is no argument, then the script initiates a PEM simulation from scratch.
#   - If the argument is 're', then the script relaunches an existing PEM simulation.
#     It will ask for parameters to know the starting point that you want to. 
########################################################################


########################################################################
# Modify here the parameters for the simulation
###############################################
# Set the number of years to be simulated, either Martian or Earth years:
n_mars_years=100
#n_earth_years=300

# Set the number of initial PCM runs:
nPCM_ini=3

# Set the number of PCM runs between each PEM run:
nPCM=2
########################################################################


dir=`pwd`
machine=`hostname`
user=`whoami`
if [ ! -f "lib_launchPEM.sh" ]; then
    echo "Error: file \"lib_launchPEM.sh\" does not exist in $dir!"
    echo "It can be found in the PEM deftank."
    exit 1
fi

source lib_launchPEM.sh

if [ $# -eq 0 ]; then # From scratch
    echo "The launching script is starting!"
    echo "The output file is \"log_launchPEM.txt\"."
    exec > log_launchPEM.txt 2>&1
    echo "Beginning of the launching script for the PEM simulation."
    date
    checklaunch
    initlaunch
    cyclelaunch $nPCM_ini
else
    if [ $1 = "new" ]; then # New cycle
        exec >> log_launchPEM.txt 2>&1
        echo "This is a new cycle for the PEM simulation."
        date
        read i_myear n_myear convert_years iPCM iPEM nPCM nPCM_ini < info_PEM.txt
        cyclelaunch $nPCM
    elif [ $1 = "re" ]; then # Relaunch
        echo "Case not coded yet!"
        errlaunch
    else
        echo "Error: given argument '$1' for the launching script is unknown!"
        errlaunch
    fi
fi
