c ------------------------------------
c ---  Data for chemical routines  ---
c ------------------------------------
c
      integer nd, nozo, nr, nsza, ntemp, ntau
c
      parameter (nd    = 29)
      parameter (nozo  = 7)
      parameter (nr    = nd + 28)
      parameter (nsza  = 27)
      parameter (ntemp = 4)
      parameter (ntau  = 8)
c
      real kb
      parameter (kb = 1.3806e-23)
c
      common/chimiedata/jphot,colairtab,table_ozo
c
      real jphot(ntemp,nsza,0:200,nozo,ntau,nd)
      real colairtab(0:200)
      real szatab(nsza)
      real table_ozo(nozo)
      real tautab(ntau)
c
      data szatab/0.,  5., 10., 15., 20., 25.,
     $            30., 35., 40., 45., 50., 55.,
     $            60., 65., 70., 75., 80., 82.,
     $            84., 86., 88., 90., 91., 92.,
     $            93., 94., 95./
c
      data tautab/0., 0.2, 0.4, 0.6, 0.8, 1., 2., 4./
c
      integer       ncomp
      parameter    (ncomp = 15)
      character*10  nomchem(ncomp)
      data          nomchem/"co2","co","o","o1d","o2","o3","h","h2",
     $                      "oh","ho2","h2o2", "ch4", "n2", "ar", "h2o"/
c
      real mmolchem(ncomp)
      data mmolchem/44.,28.,16.,16.,32.,48., 1.,
     $               2.,17.,33.,34.,16.,28.,40.,18./
