      MODULE surfini_mod
      
      IMPLICIT NONE
      
      CONTAINS

      SUBROUTINE surfini(ngrid,nq,qsurf,albedo,albedo_bareground,
     &                   albedo_snow_SPECTV,albedo_co2_ice_SPECTV)

      USE surfdat_h, only: albedodat ! bare ground albedo
      use planetwide_mod, only: planetwide_maxval, planetwide_minval
      use radinc_h, only : L_NSPECTV ! number of spectral bands in the visible
      use callkeys_mod, only : albedosnow, albedoco2ice

      IMPLICIT NONE
      
      
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccc                                                                 cccccccccccccc
cccccccccccccc   Spectral Albedo Initialisation - Routine modified by MT2015.  cccccccccccccc
cccccccccccccc                                                                 cccccccccccccc 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


c--------------------
c   Declarations:
c--------------------

      INTEGER,INTENT(IN) :: ngrid
      INTEGER,INTENT(IN) :: nq
      REAL,INTENT(IN) :: albedo(ngrid,L_NSPECTV)
      REAL,INTENT(OUT) :: albedo_bareground(ngrid)
      REAL,INTENT(OUT) :: albedo_snow_SPECTV(L_NSPECTV)
      REAL,INTENT(OUT) :: albedo_co2_ice_SPECTV(L_NSPECTV)
      REAL,INTENT(IN) :: qsurf(ngrid,nq) ! tracer on surface (kg/m2)

      INTEGER :: ig,nw
      REAL :: min_albedo,max_albedo

c=======================================================================

      ! Step 1 : Initialisation of the Spectral Albedos.
      DO nw=1,L_NSPECTV
         albedo_snow_SPECTV(nw)=albedosnow
         albedo_co2_ice_SPECTV(nw)=albedoco2ice
      ENDDO


      ! Step 2 : We get the bare ground albedo from the start files.
      DO ig=1,ngrid
         albedo_bareground(ig)=albedodat(ig)
      ENDDO
      call planetwide_minval(albedo_bareground,min_albedo)
      call planetwide_maxval(albedo_bareground,max_albedo)
      write(*,*) 'surfini: minimum bare ground albedo',min_albedo
      write(*,*) 'surfini: maximum bare ground albedo',max_albedo


      ! Step 3 : Surface albedo already loaded from startfi.nc
      ! merely report vmin/max values here

      call planetwide_minval(albedo,min_albedo)
      call planetwide_maxval(albedo,max_albedo)
      write(*,*) 'surfini: minimum corrected initial albedo',min_albedo
      write(*,*) 'surfini: maximum corrected initial albedo',max_albedo


      END SUBROUTINE surfini
      
      END MODULE surfini_mod
