!==================================================================
module aerosol_mod
implicit none

!==================================================================

!  aerosol indexes: these are initialized to be 0 if the
!                 corresponding aerosol was not activated in callphys.def
!                 -- otherwise a value is set via iniaerosol
      integer, save :: iaero_haze = 0
      integer, save :: i_haze = 0
      logical, save, protected :: noaero = .false.
!$OMP THREADPRIVATE(iaero_haze,i_haze,noaero)

! two-layer simple aerosol model
      integer, save, protected :: iaero_back2lay = 0
! N-layer aerosol model (replaces the 2-layer and hard-coded clouds)
      integer,dimension(:), allocatable, save, protected :: iaero_nlay
!$OMP THREADPRIVATE(iaero_back2lay,iaero_nlay)

! Generic aerosols
      integer, dimension(:), allocatable, save, protected :: iaero_generic
      integer, dimension(:), allocatable, save, protected :: i_rgcs_ice
!$OMP THREADPRIVATE(iaero_generic,i_rgcs_ice)

!==================================================================

contains

  !==================================================================
   subroutine haze_prof(ngrid,nlayer,zzlay,pplay,pt,reffrad,profmmr)
!==================================================================
!     Purpose
!     -------
!     Get fixed haze properties
!     profile of haze (from txt file) and fixed radius profile
!
!==================================================================
      use radinc_h, only: naerkind
      use datafile_mod
      use tracer_h
      use comcstfi_mod, only: r, pi

!-----------------------------------------------------------------------
!     Arguments
      Implicit none

      integer,intent(in) :: ngrid
      integer,intent(in) :: nlayer
      real,intent(in) :: zzlay(ngrid,nlayer)
      real,intent(in) :: pplay(ngrid,nlayer)
      real,intent(in) :: pt(ngrid,nlayer)
      real, intent(in) :: reffrad(ngrid,nlayer,naerkind)      ! haze particles radii (m)

      real, intent(out) :: profmmr(ngrid,nlayer)              ! mmr haze kg/kg

!     Local variables
      integer :: iaer,l,ig,ifine

      LOGICAL firstcall
      SAVE firstcall
      DATA firstcall/.true./

      !!read altitudes and haze mmrs
      integer Nfine
      !parameter(Nfine=21)
      parameter(Nfine=701)
      character(len=100) :: file_path
      real,save :: levdat(Nfine),densdat(Nfine)

!---------------- INPUT ------------------------------------------------

      !! Read data
      IF (firstcall) then
        firstcall=.false.
        file_path=trim(datadir)//'/haze_prop/'//hazemmr_file
        open(224,file=file_path,form='formatted')
        do ifine=1,Nfine
           read(224,*) levdat(ifine), densdat(ifine)
        enddo
        close(224)
        print*, 'TB22 read Haze MMR profile'
      ENDIF

      !! Interpolate on the model vertical grid
      do ig=1,ngrid
        CALL interp_line(levdat,densdat,Nfine,zzlay(ig,:)/1000.,profmmr(ig,:),nlayer)
      enddo

      !! Get profile Mass mixing ratio from number density:    part.cm-3 --> m-3 --> m3 m-3
      !                                --> kg m-3 --> kg/kg
      do iaer=1,naerkind
            if(iaer.eq.iaero_haze.and.1.eq.2) then !TB22 activate/deactivate mmr or part density
              !print*, 'Haze profile is fixed'
              do ig=1,ngrid
                 do l=1,nlayer
                    !from number density in cm-3
                    profmmr(ig,l)=profmmr(ig,l)*1.e6*4./3.*pi*reffrad(ig,l,iaer)**3*rho_q(i_haze)/(pplay(ig,l)/(r*pt(ig,l)))
                 enddo
              enddo
            endif
      enddo
   end subroutine haze_prof
!==================================================================


end module aerosol_mod
!==================================================================
