MODULE phys_state_var_init_mod

CONTAINS

      SUBROUTINE phys_state_var_init(filename,ngrid,nlayer,nq,tname, &
                                     day_ini,day_end,hour_ini,pdaysec,ptimestep, &
                                     prad,pg,pr,pcpp, &
                                     dyn_nqperes,dyn_nqfils)! MVals: variables isotopes

!=======================================================================
!
!   purpose:
!   -------
!
!   Allocate arrays in modules
!   Fill geometrical arrays
!   Fill a first set of physical constants
!   -- was done previously in inifis
!
!=======================================================================
!   
!   authors: Ehouarn Millour and Aymeric Spiga
!            14/04/2014
!
!   arguments:
!   ----------
!
!   input:
!   ------
!
!    ngrid                 Size of the horizontal grid.
!    nlayer                Number of vertical layers.
!    nq                    Number of tracers.
!
!=======================================================================

      use init_print_control_mod, only: init_print_control
      use slope_mod, only: ini_slope_mod,end_slope_mod
      use comsaison_h, only: ini_comsaison_h,end_comsaison_h
      use surfdat_h, only: ini_surfdat_h,end_surfdat_h
      use comgeomfi_h, only: ini_comgeomfi_h,end_comgeomfi_h
      use comsoil_h, only: ini_comsoil_h,end_comsoil_h
      use dimradmars_mod, only: ini_dimradmars_mod,end_dimradmars_mod
      use yomlw_h, only: ini_yomlw_h,end_yomlw_h
      use conc_mod, only: ini_conc_mod,end_conc_mod
      use turb_mod, only: ini_turb_mod,end_turb_mod
      use comcstfi_h, only: init_comcstfi_h
      use tracer_mod, only: ini_tracer_mod,end_tracer_mod
      use time_phylmdz_mod, only: init_time
      use compute_dtau_mod, only: ini_compute_dtau_mod, &
                                  end_compute_dtau_mod
      use rocketduststorm_mod, only: ini_rocketduststorm_mod, &
                                     end_rocketduststorm_mod
      use calchim_mod, only: ini_calchim_mod,end_calchim_mod
      use watercloud_mod, only: ini_watercloud_mod, &
                                end_watercloud_mod
      use nonoro_gwd_ran_mod, only: ini_nonoro_gwd_ran, &
                                    end_nonoro_gwd_ran
      use nonoro_gwd_mix_mod, only: ini_nonoro_gwd_mix, &
                                    end_nonoro_gwd_mix
      use dust_param_mod, only: ini_dust_param_mod, &
                                end_dust_param_mod
      use dust_rad_adjust_mod, only: ini_dust_rad_adjust_mod, &
                                     end_dust_rad_adjust_mod
      use comslope_mod, ONLY: nslope,end_comslope_h,ini_comslope_h
      use paleoclimate_mod, ONLY: end_paleoclimate_h,ini_paleoclimate_h
      use netcdf
      USE mod_phys_lmdz_para, ONLY: is_master,bcast

      IMPLICIT NONE

      character(*), intent(in) :: filename ! Name of the "startfi.nc" file
      integer,      intent(IN) :: ngrid,nlayer,nq
      character(*), intent(IN) :: tname(nq)
      integer,      intent(IN) :: day_ini, day_end
      real,         intent(IN) :: hour_ini
      real,         intent(IN) :: pdaysec, ptimestep, prad, pg, pr, pcpp
!MVals isotopes
      integer,      intent(in) :: dyn_nqperes
      integer,      intent(in) :: dyn_nqfils(nq)
      integer :: ncid, status, nslope_dim_id
      integer :: nslope_read

      if(is_master) then
        status = nf90_open(filename, nf90_nowrite, ncid)
        if (status /= nf90_noerr) then
          nslope=1
        else
          status = nf90_inq_dimid(ncid, "nslope", nslope_dim_id)
          if (status /= nf90_noerr) then
            nslope=1
          else
            status = nf90_inquire_dimension(ncid, nslope_dim_id, len = nslope_read)
            if (status /= nf90_noerr) then
              call abort_physic("phys_state_var_init","nslope present but not readable",1)
            else
              nslope=nslope_read
            endif
          endif
        endif
      endif
      call bcast(nslope)

      ! set dimension and allocate arrays in tracer_mod
      call end_tracer_mod
      call ini_tracer_mod(nq,tname,dyn_nqperes,dyn_nqfils)! MVals: variables isotopes

      ! initialize "print_control" constants/flags ("prt_level","lunout", etc.)
      call init_print_control
      
      ! set parameters in comcstfi_h
      call init_comcstfi_h(prad,pcpp,pg,pr)

      ! Initialize some "temporal and calendar" related variables
      call init_time(day_ini,day_end,hour_ini,pdaysec,ptimestep)

      ! allocate "slope_mod" arrays
      call end_slope_mod
      call ini_slope_mod(ngrid)

      ! allocate "comsaison_h" arrays
      call end_comsaison_h
      call ini_comsaison_h(ngrid)

      ! allocate "surfdat_h" arrays
      call end_surfdat_h
      call ini_surfdat_h(ngrid,nq,nslope)

      ! allocate "comgeomfi_h" arrays
      call end_comgeomfi_h
      call ini_comgeomfi_h(ngrid)

      ! allocate "comsoil_h" arrays
      call end_comsoil_h
      call ini_comsoil_h(ngrid,nslope)

      ! set some variables in "dimradmars_mod"
      call end_dimradmars_mod
      call ini_dimradmars_mod(ngrid,nlayer,nslope)

      ! allocate arrays in "yomlw_h"
      call end_yomlw_h
      call ini_yomlw_h(ngrid)

      ! allocate arrays in "conc_mod" (aeronomars)
      call end_conc_mod
      call ini_conc_mod(ngrid,nlayer)

      ! allocate arrays in "turb_mod"
      call end_turb_mod
      call ini_turb_mod(ngrid,nlayer)

      ! allocate arrays in "compute_dtau_mod":
      call end_compute_dtau_mod
      call ini_compute_dtau_mod(ngrid)

      ! allocate arrays in "rocketduststorm_mod":
      call end_rocketduststorm_mod
      call ini_rocketduststorm_mod(ngrid)

      ! allocate arrays in "calchim_mod" (aeronomars)
      call end_calchim_mod
      call ini_calchim_mod(ngrid,nlayer,nq)

      ! allocate arrays in "watercloud_mod"
      call end_watercloud_mod
      call ini_watercloud_mod(ngrid,nlayer,nq)

      ! allocate arrays in "nonoro_gwd_ran_mod"
      call end_nonoro_gwd_ran
      call ini_nonoro_gwd_ran(ngrid,nlayer)

      ! allocate arrays in "nonoro_gwd_mix_mod"
      call end_nonoro_gwd_mix
      call ini_nonoro_gwd_mix(ngrid,nlayer)

      ! allocate arrays in "dust_param_mod"
      call end_dust_param_mod
      call ini_dust_param_mod(ngrid)
      
      ! allocate arrays in "dust_rad_adjust_mod"
      call end_dust_rad_adjust_mod
      call ini_dust_rad_adjust_mod(ngrid)

      ! allocate arrays in "comslope_mod"
      call end_comslope_h
      call ini_comslope_h(ngrid,nslope)

      ! allocate arrays in "paleoclimate_mod"
      call end_paleoclimate_h
      call ini_paleoclimate_h(ngrid,nslope)

      END SUBROUTINE phys_state_var_init

END MODULE phys_state_var_init_mod
