
       module tracer_h

       implicit none

       integer, save :: nqtot ! total number of tracers
       integer, save :: nesp  ! number of species in the chemistry
       integer, save :: ngt   ! number of generic tracers
       integer, save :: n_rgcs ! number of Radiative Generic Condensable Species
!$OMP THREADPRIVATE(nqtot,nesp,ngt,n_rgcs)

       logical :: moderntracdef=.false. ! Standard or modern traceur.def
!$OMP THREADPRIVATE(moderntracdef)

       character*30, save, allocatable :: noms(:)   ! name of the tracer
       real, save, allocatable :: mmol(:)     ! mole mass of tracer (g/mol)
       real, save, allocatable :: aki(:)      ! to compute coefficient of thermal concduction if photochem
       real, save, allocatable :: cpi(:)      ! to compute cpnew in concentration.F if photochem
       real, save, allocatable :: radius(:)   ! dust and ice particle radius (m)
       real, save, allocatable :: rho_q(:)    ! tracer densities (kg.m-3)
       real, save, allocatable :: qext(:)     ! Single Scat. Extinction coeff at 0.67 um
       real, save, allocatable :: alpha_lift(:)  ! saltation vertical flux/horiz flux ratio (m-1)
       real, save, allocatable :: alpha_devil(:) ! lifting coeeficient by dust devil
       real, save, allocatable :: qextrhor(:) ! Intermediate for computing opt. depth from q

       real,save :: varian      ! Characteristic variance of log-normal distribution
       real,save :: r3n_q     ! used to compute r0 from number and mass mixing ratio
       real,save :: rho_dust     ! Mars dust density (kg.m-3)
       real,save :: rho_ice     ! Water ice density (kg.m-3)
       real,save :: rho_ch4_ice     ! ch4 ice density (kg.m-3)
       real,save :: rho_co_ice     ! co ice density (kg.m-3)
       real,save :: rho_n2     ! N2 ice density (kg.m-3)
       real,save :: lw_ch4     ! Latent heat CH4 gas -> solid
       real,save :: lw_co      ! Latent heat CO gas -> solid
       real,save :: lw_n2      ! Latent heat N2 gas -> solid
       integer,save :: nmono
       real,save :: ref_r0        ! for computing reff=ref_r0*r0 (in log.n. distribution)
!$OMP THREADPRIVATE(noms,mmol,aki,cpi,radius,rho_q,qext,alpha_lift,alpha_devil,qextrhor, &
	!$OMP varian,r3n_q,rho_dust,rho_ice,rho_n2,lw_n2,ref_r0)

       integer, save, allocatable :: is_chim(:) ! 1 if tracer used in chemistry, else 0
       integer, save, allocatable :: is_rad(:)  ! 1 if   ""    ""  in radiative transfer, else 0
!$OMP THREADPRIVATE(is_chim,is_rad)

       integer, save, allocatable :: is_recomb(:)      ! 1 if tracer used in recombining scheme, else 0 (if 1, must have is_rad=1)
       integer, save, allocatable :: is_recomb_qset(:) ! 1 if tracer k-corr assume predefined vmr, else 0 (if 1, must have is_recomb=1)
       integer, save, allocatable :: is_recomb_qotf(:) ! 1 if tracer recombination is done on-the-fly, else 0 (if 1, must have is_recomb_qset=0)
!$OMP THREADPRIVATE(is_recomb,is_recomb_qset,is_recomb_qotf)
       integer, save, allocatable :: is_condensable(:)      ! 1 if tracer is generic, else 0 (added LT)
       integer,save,allocatable :: is_rgcs(:)               ! 1 if tracer is a radiative generic condensable specie, else 0 (added LT 2022)
       ! Lists of constants for condensable tracers
       real, save, allocatable :: constants_mass(:)                    ! molecular mass of the specie (g/mol)
       real, save, allocatable :: constants_delta_vapH(:)           ! Enthalpy of vaporization (J/mol)
       real, save, allocatable :: constants_Tref(:)                 ! Ref temperature for Clausis-Clapeyron (K)
       real, save, allocatable :: constants_Pref(:)                 ! Reference pressure for Clausius Clapeyron (Pa)
       real, save, allocatable :: constants_epsi_generic(:)                 ! fractionnal molecular mass (m/mugaz)
       real, save, allocatable :: constants_RLVTT_generic(:)                ! Latent heat of vaporization (J/kg)
       real, save, allocatable :: constants_metallicity_coeff(:)    ! Coefficient to take into account the metallicity
       real, save, allocatable :: constants_RCPV_generic(:)                   ! specific heat capacity of the tracer vapor at Tref
!$OMP THREADPRIVATE(constants_mass,constants_delta_vapH,constants_Tref)
!$OMP THREADPRIVATE(constants_Pref,constants_epsi_generic)
!$OMP THREADPRIVATE(constants_RLVTT_generic,constants_metallicity_coeff,constants_RCPV_generic)

!$OMP THREADPRIVATE(is_condensable,is_rgcs)   !also added by LT
! tracer indexes: these are initialized in initracer and should be 0 if the
!                 corresponding tracer does not exist

       !Pluto chemistry
       integer,save :: igcm_co_gas
       integer,save :: igcm_n2
       integer,save :: igcm_ar
       integer,save :: igcm_ch4_gas ! methane gas
       ! other tracers
       integer,save :: igcm_ar_n2 ! for simulations using co2 +neutral gaz
       integer,save :: igcm_ch4_ice ! methane ice
       integer,save :: igcm_co_ice ! methane ice
       integer,save :: igcm_prec_haze
       integer,save :: igcm_haze
       integer,save :: igcm_haze10
       integer,save :: igcm_haze30
       integer,save :: igcm_haze50
       integer,save :: igcm_haze100
       integer,save :: igcm_eddy1e6
       integer,save :: igcm_eddy1e7
       integer,save :: igcm_eddy5e7
       integer,save :: igcm_eddy1e8
       integer,save :: igcm_eddy5e8

!$OMP THREADPRIVATE(igcm_co_gas,igcm_n2,igcm_ar,igcm_ch4_gas,igcm_ar_n2,igcm_ch4_ice,igcm_co_ice,igcm_prec_haze,igcm_haze,igcm_haze10,igcm_haze30,igcm_haze50,igcm_haze100,igcm_eddy1e6,igcm_eddy1e7,igcm_eddy5e7,igcm_eddy1e8,igcm_eddy5e8)

       end module tracer_h

