MODULE callkeys_mod
IMPLICIT NONE  

      logical,save :: callrad,corrk,calldifv,UseTurbDiff
!$OMP THREADPRIVATE(callrad,corrk,calldifv,UseTurbDiff)
      logical,save :: calladj,calltherm,n2cond,callsoil
!$OMP THREADPRIVATE(calladj,calltherm,n2cond,callsoil)
      logical,save :: season,diurnal,lwrite
!$OMP THREADPRIVATE(season,diurnal,lwrite)
      logical,save :: callgasvis,continuum,graybody
!$OMP THREADPRIVATE(callgasvis,continuum,graybody)
      logical,save :: strictboundcorrk                                     
!$OMP THREADPRIVATE(strictboundcorrk)
      logical,save :: strictboundcia                                     
!$OMP THREADPRIVATE(strictboundcia)

      logical,save :: enertest
      logical,save :: nonideal
      logical,save :: meanOLR
      logical,save :: specOLR
      logical,save :: kastprof
      logical,save :: diagdtau
!$OMP THREADPRIVATE(enertest,nonideal,meanOLR,kastprof,diagdtau)
      logical,save :: newtonian
      logical,save :: force_cpp
      integer,save :: cpp_mugaz_mode
      logical,save :: testradtimes
      logical,save :: rayleigh
!$OMP THREADPRIVATE(newtonian,force_cpp,cpp_mugaz_mode,testradtimes,rayleigh)
      logical,save :: stelbbody
      logical,save :: nearn2cond
      logical,save :: tracer
      logical,save :: mass_redistrib
!$OMP THREADPRIVATE(stelbbody,nearn2cond,tracer,mass_redistrib)
      logical,save :: varactive
      logical,save :: varfixed
      logical,save :: sedimentation
      logical,save :: generic_condensation
!$OMP THREADPRIVATE(varactive,varfixed,sedimentation,generic_condensation,generic_rain)
      logical,save :: aeron2, aeroh2o, aeroh2so4, aeroback2lay
!$OMP THREADPRIVATE(aeron2, aeroh2o, aeroh2so4, aeroback2lay)
      logical,save :: aeronh3, aeronlay, aeroaurora
!$OMP THREADPRIVATE(aeronh3,aeronlay,aeroaurora)

      logical,save :: aerofixn2
!$OMP THREADPRIVATE(aerofixn2)
      integer,save :: aerogeneric ! number of aerosols of "generic" kind
!$OMP THREADPRIVATE(aerogeneric)
      logical,save :: nosurf
!$OMP THREADPRIVATE(nosurf)
      logical,save :: albedo_spectral_mode
!$OMP THREADPRIVATE(albedo_spectral_mode)
      logical,save :: photoheat
      logical,save :: jonline
      logical,save :: depos
!$OMP THREADPRIVATE(photoheat,jonline,depos)

!! Pluto-specific variables
      logical,save :: haze_radproffix,haze_proffix 
!$OMP THREADPRIVATE(haze_radproffix,haze_proffix)      
      logical,save :: haze,fasthaze,changeti,changetid,aerohaze         
!$OMP THREADPRIVATE(haze,fasthaze,changeti,changetid,aerohaze)      
      logical,save :: fast,metcloud,monoxcloud,glaflow,triton,paleo,nlte,strobel
!$OMP THREADPRIVATE(fast,metcloud,monoxcloud,glaflow,triton,paleo,nlte,strobel      
      logical,save :: kbo,nbsub,cooling,mode_n2,thres_n2ice,thres_coice 
!$OMP THREADPRIVATE(kbo,nbsub,cooling,mode_n2,thres_n2ice,thres_coice)      
      logical,save :: deltab,nb_monomer                                 
!$OMP THREADPRIVATE(deltab,nb_monomer)      
      logical,save :: metlateq,tholateq,metls1,metls2                   
!$OMP THREADPRIVATE(metlateq,tholateq,metls1,metls2)      
      logical,save :: mode_ch4,mode_tholins                             
!$OMP THREADPRIVATE(mode_ch4,mode_tholins)      
      logical,save :: source_haze,ch4lag,latlag,vmrlag,kfix,hazeconservch4      
!$OMP THREADPRIVATE(source_haze,ch4lag,latlag,vmrlag,kfix,hazeconservch4)      
      logical,save :: fracsource,latsource,lonsource                    
!$OMP THREADPRIVATE(fracsource,latsource,lonsource)      
      logical,save :: spelon1,spelon2,spelat1,spelat2,specalb           
!$OMP THREADPRIVATE(spelon1,spelon2,spelat1,spelat2,specalb)      
      logical,save :: assymflux,mode_hs,tsurfmax,albmin_ch4
!$OMP THREADPRIVATE(assymflux,mode_hs,tsurfmax,albmin_ch4)      
      logical,save :: feedback_met,thres_ch4ice,fdch4_latn,fdch4_lats   
!$OMP THREADPRIVATE(feedback_met,thres_ch4ice,fdch4_latn,fdch4_lats)      
      logical,save :: globmean1d,kmix_proffix,rad_haze          
!$OMP THREADPRIVATE(globmean1d,kmix_proffix,rad_haze)      
      logical,save :: fdch4_lone,fdch4_lonw,fdch4_maxalb,fdch4_depalb,fdch4_finalb
!$OMP THREADPRIVATE(fdch4_lone,fdch4_lonw,fdch4_maxalb,fdch4_depalb,fdch4_finalb      
      logical,save :: tholatn,tholats,tholone,tholonw                   
!$OMP THREADPRIVATE(tholatn,tholats,tholone,tholonw)      
      logical,save :: fdch4_ampl,fdch4_maxice,condmetsurf,condcosurf,vertdiff   
!$OMP THREADPRIVATE(fdch4_ampl,fdch4_maxice,condmetsurf,condcosurf,vertdiff)      
      logical,save :: convergeps,conservn2,patchflux,condensn2,no_n2frost
!$OMP THREADPRIVATE(convergeps,conservn2,patchflux,condensn2,no_n2frost      


      logical,save :: global1d
      real,save    :: szangle
!$OMP THREADPRIVATE(global1d,szangle)

      integer,save :: iddist
      integer,save :: iaervar
      integer,save :: iradia
      integer,save :: startype
      integer,save :: versH2H2cia
      character(64),save :: H2orthopara_mixture
      integer,save :: nlayaero
!$OMP THREADPRIVATE(iddist,iaervar,iradia,startype,versH2H2cia,H2orthopara_mixture,nlayaero)
      integer,dimension(:),allocatable,save :: aeronlay_choice
!$OMP THREADPRIVATE(aeronlay_choice)

      character(64),save :: optprop_back2lay_vis
      character(64),save :: optprop_back2lay_ir
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_vis
      character(64),dimension(:),allocatable,save :: optprop_aeronlay_ir
!$OMP THREADPRIVATE(optprop_back2lay_vis,optprop_back2lay_ir,optprop_aeronlay_vis,optprop_aeronlay_ir)

      real,save :: tplanckmin
      real,save :: tplanckmax
      real,save :: dtplanck
!$OMP THREADPRIVATE(tplanckmin,tplanckmax,dtplanck)
      real,save :: topdustref
      real,save :: dusttau
      real,save :: Fat1AU
      real,save :: stelTbb
!$OMP THREADPRIVATE(topdustref,dusttau,Fat1AU,stelTbb)
      real,save :: Tstrat
      real,save :: tplanet
      real,save :: obs_tau_col_tropo
      real,save :: obs_tau_col_strato
!$OMP THREADPRIVATE(Tstrat,tplanet,obs_tau_col_tropo,obs_tau_col_strato)
      real,save :: pres_bottom_tropo
      real,save :: pres_top_tropo
      real,save :: pres_bottom_strato
      real,save :: pres_top_strato
!$OMP THREADPRIVATE(pres_bottom_tropo,pres_top_tropo,pres_bottom_strato,pres_top_strato)
      real,save :: size_tropo
      real,save :: size_strato
      real,save :: satval
      real,save :: n2mixratio
!$OMP THREADPRIVATE(size_tropo,size_strato,satval,n2mixratio)
      real,save :: size_nh3_cloud
      real,save :: pres_nh3_cloud
      real,save :: tau_nh3_cloud
!$OMP THREADPRIVATE(size_nh3_cloud, pres_nh3_cloud, tau_nh3_cloud)
      real,dimension(:),allocatable,save :: aeronlay_tauref
      real,dimension(:),allocatable,save :: aeronlay_lamref
      real,dimension(:),allocatable,save :: aeronlay_ptop
      real,dimension(:),allocatable,save :: aeronlay_pbot
      real,dimension(:),allocatable,save :: aeronlay_sclhght
      real,dimension(:),allocatable,save :: aeronlay_size
      real,dimension(:),allocatable,save :: aeronlay_nueff
!$OMP THREADPRIVATE(aeronlay_tauref,aeronlay_lamref,aeronlay_ptop,aeronlay_pbot,aeronlay_sclhght,aeronlay_size,aeronlay_nueff)
      real,save :: n2supsat
      real,save :: pceil
      real,save :: albedosnow
      real,save :: albedon2ice
      real,save :: maxicethick
!$OMP THREADPRIVATE(n2supsat,pceil,albedosnow,albedon2ice,maxicethick)
      real,save :: Tsaldiff
      real,save :: tau_relax
      real,save :: cloudlvl
      real,save :: icetstep
      real,save :: intheat
!$OMP THREADPRIVATE(Tsaldiff,tau_relax,cloudlvl,icetstep,intheat)
      real,save :: surfalbedo
      real,save :: surfemis
!$OMP THREADPRIVATE(surfalbedo,surfemis)
      real,save :: noseason_day
!$OMP THREADPRIVATE(noseason_day)
      real,save :: kmixmin
!$OMP THREADPRIVATE(kmixmin)
      
      logical,save :: iscallphys=.false.!existence of callphys.def
!$OMP THREADPRIVATE(iscallphys)

      ! do we read a startphy.nc file (default=.true.)
      logical,save :: startphy_file=.true. 
!$OMP THREADPRIVATE(startphy_file)

END MODULE callkeys_mod
