!
! $Id: calcul_fluxs_mod.F90 3102 2017-12-03 20:27:42Z oboucher $
!
MODULE calcul_fluxs_mod


CONTAINS

  SUBROUTINE calcul_flux_wind(knon, dtime, &
       u0, v0, u1, v1, gustiness, cdrag_m, &
       AcoefU, AcoefV, BcoefU, BcoefV, &
       p1lay, t1lay, &
       flux_u1, flux_v1)

    USE dimphy
    USE comcstfi_mod, ONLY: r
!    INCLUDE "YOMCST.h"
!    INCLUDE "clesphys.h"

! Input arguments
!****************************************************************************************
    INTEGER, INTENT(IN)                  :: knon
    REAL, INTENT(IN)                     :: dtime
    REAL, DIMENSION(klon), INTENT(IN)    :: u0, v0  ! u and v at niveau 0
    REAL, DIMENSION(klon), INTENT(IN)    :: u1, v1, gustiness  ! u and v at niveau 1
    REAL, DIMENSION(klon), INTENT(IN)    :: cdrag_m ! cdrag pour momentum
    REAL, DIMENSION(klon), INTENT(IN)    :: AcoefU, AcoefV, BcoefU, BcoefV
    REAL, DIMENSION(klon), INTENT(IN)    :: p1lay   ! pression 1er niveau (milieu de couche)
    REAL, DIMENSION(klon), INTENT(IN)    :: t1lay   ! temperature 
! Output arguments
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(OUT)   :: flux_u1
    REAL, DIMENSION(klon), INTENT(OUT)   :: flux_v1

! Local variables
!****************************************************************************************
    INTEGER                              :: i
    REAL                                 :: mod_wind, buf

!****************************************************************************************
! Calculate the surface flux
!
!****************************************************************************************
    DO i=1,knon
       mod_wind = min_wind_speed + SQRT(gustiness(i)+(u1(i) - u0(i))**2 + (v1(i)-v0(i))**2)
       buf = cdrag_m(i) * mod_wind * p1lay(i)/(r*t1lay(i))
       flux_u1(i) = (AcoefU(i) - u0(i)) / (1/buf - BcoefU(i)*dtime )
       flux_v1(i) = (AcoefV(i) - v0(i)) / (1/buf - BcoefV(i)*dtime )
    END DO

  END SUBROUTINE calcul_flux_wind
!
!****************************************************************************************
!
END MODULE calcul_fluxs_mod
