MODULE write_output_mod

implicit none

private

INTERFACE write_output
    MODULE PROCEDURE write_output_d0, write_output_d1, write_output_d2, &
                     write_output_i0, write_output_i1, write_output_i2, &
                     write_output_l0, write_output_l1, write_output_l2
END INTERFACE write_output

public write_output

!-----------------------------------------------------------------------
contains
!-----------------------------------------------------------------------

SUBROUTINE write_output_d0(field_name,title,units,field)
! For a scalar

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*), intent(in) :: field_name
character(*), intent(in) :: title
character(*), intent(in) :: units
real,         intent(in) :: field

call writediagfi(ngrid,field_name,title,units,0,(/field/))
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field)
#endif

END SUBROUTINE write_output_d0

!-----------------------------------------------------------------------

SUBROUTINE write_output_d1(field_name,title,units,field)
! For a surface field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),       intent(in) :: field_name
character(*),       intent(in) :: title
character(*),       intent(in) :: units
real, dimension(:), intent(in) :: field

call writediagfi(ngrid,field_name,title,units,2,field)
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field)
#endif

END SUBROUTINE write_output_d1

!-----------------------------------------------------------------------

SUBROUTINE write_output_d2(field_name,title,units,field)
! For a "3D" horizontal-vertical field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

use comsoil_h,         only: nsoilmx
use writediagsoil_mod, only: writediagsoil

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),         intent(in) :: field_name
character(*),         intent(in) :: title
character(*),         intent(in) :: units
real, dimension(:,:), intent(in) :: field

if (size(field,2) == nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,field)
else
    call writediagfi(ngrid,field_name,title,units,3,field)
endif

#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field)
#endif

END SUBROUTINE write_output_d2

!-----------------------------------------------------------------------

SUBROUTINE write_output_i0(field_name,title,units,field)
! For a scalar

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*), intent(in) :: field_name
character(*), intent(in) :: title
character(*), intent(in) :: units
integer,      intent(in) :: field

call writediagfi(ngrid,field_name,title,units,0,(/real(field)/))
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,(/real(field)/))
#endif

END SUBROUTINE write_output_i0

!-----------------------------------------------------------------------

SUBROUTINE write_output_i1(field_name,title,units,field)
! For a surface field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),          intent(in) :: field_name
character(*),          intent(in) :: title
character(*),          intent(in) :: units
integer, dimension(:), intent(in) :: field

call writediagfi(ngrid,field_name,title,units,2,real(field))
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,real(field))
#endif

END SUBROUTINE write_output_i1

!-----------------------------------------------------------------------

SUBROUTINE write_output_i2(field_name,title,units,field)
! For a "3D" horizontal-vertical field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

use comsoil_h,         only: nsoilmx
use writediagsoil_mod, only: writediagsoil

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),            intent(in) :: field_name
character(*),            intent(in) :: title
character(*),            intent(in) :: units
integer, dimension(:,:), intent(in) :: field

if (size(field,2) == nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,real(field))
else
    call writediagfi(ngrid,field_name,title,units,3,real(field))
endif
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,real(field))
#endif

END SUBROUTINE write_output_i2

!-----------------------------------------------------------------------

SUBROUTINE write_output_l0(field_name,title,units,field)
! For a scalar
 
#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*), intent(in) :: field_name
character(*), intent(in) :: title
character(*), intent(in) :: units
logical,      intent(in) :: field
! Local argument used to convert logical to real array
real, dimension(1) :: field_real

field_real = 0.
if (field) field_real = 1.

call writediagfi(ngrid,field_name,title,units,0,field_real)
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field_real)
#endif

END SUBROUTINE write_output_l0

!-----------------------------------------------------------------------

SUBROUTINE write_output_l1(field_name,title,units,field)
! For a surface field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),          intent(in) :: field_name
character(*),          intent(in) :: title
character(*),          intent(in) :: units
logical, dimension(:), intent(in) :: field
! Local argument used to convert logical to real
real, dimension(ngrid) :: field_real

field_real = 0.
where (field) field_real = 1.

call writediagfi(ngrid,field_name,title,units,2,field_real)
#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field_real)
#endif

END SUBROUTINE write_output_l1

!-----------------------------------------------------------------------

SUBROUTINE write_output_l2(field_name,title,units,field)
! For a "3D" horizontal-vertical field

#ifdef CPP_XIOS
    use xios_output_mod, only: xios_is_active_field
    use xios_output_mod, only: send_xios_field
#endif

use comsoil_h,         only: nsoilmx
use writediagsoil_mod, only: writediagsoil

implicit none

include "dimensions.h"

integer, parameter :: ngrid = 2 + (jjm - 1)*iim - 1/jjm
character(*),            intent(in) :: field_name
character(*),            intent(in) :: title
character(*),            intent(in) :: units
logical, dimension(:,:), intent(in) :: field
! Local argument used to convert logical to real
real, allocatable, dimension(:,:) :: field_real

allocate(field_real(size(field,1),size(field,2)))
field_real = 0.
where (field) field_real = 1.

if (size(field,2) == nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,field_real)
else
    call writediagfi(ngrid,field_name,title,units,3,field_real)
endif

#ifdef CPP_XIOS
    ! only send the field to xios if the user asked for it
    if (xios_is_active_field(field_name)) call send_xios_field(field_name,field_real)
#endif

deallocate(field_real)

END SUBROUTINE write_output_l2

END MODULE write_output_mod
