MODULE time_evol_mod

implicit none

integer :: year_bp_ini    ! Initial year (in Planetary years) of the simulation of the PEM defined in run.def (in Earth years)
integer :: dt_pem         ! Time step used by the PEM in Planetary years
real    :: convert_years  ! Conversion ratio from Planetary years to Earth years
real    :: h2o_ice_crit   ! Percentage of change of the surface of h2o ice sublimating before stopping the PEM
real    :: co2_ice_crit   ! Percentage of change of the surface of co2 ice sublimating before stopping the PEM
real    :: ps_criterion   ! Percentage of change of averaged surface pressure before stopping the PEM
integer :: Max_iter_pem   ! Maximal number of iteration when converging to a steady state, read in evol.def
logical :: evol_orbit_pem ! True if we want to follow the orbital parameters of obl_ecc_lsp.asc, read in evol.def
logical :: var_obl        ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for obliquity
logical :: var_ecc        ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for eccenticity
logical :: var_lsp        ! True if we want the PEM to follow obl_ecc_lsp.asc parameters for ls perihelie

END MODULE time_evol_mod
