MODULE constants_marspem_mod

implicit none

! Duration of a year and day 
integer, parameter :: sols_per_my = 669    ! Number of Sols per year
real,    parameter :: sec_per_sol = 88775. ! Duration of a sol, in seconds

! Molecular masses for CO2,H2O and non condensible gaz, following Franz et al. 2017    
real, parameter :: m_co2 = 44.01e-3    ! CO2 molecular mass (kg/mol)   
real, parameter :: m_noco2 = 33.37e-3  ! Non condensible mol mass (kg/mol)   
real, parameter :: m_h2o = 18.01528e-3 ! Molecular weight of h2o (kg/mol)

!     Coefficient for Clapeyron law for CO2 condensation temperature (Tco2 = beta/(alpha-log(vmr)),following James et al. 1992
real, parameter :: alpha_clap_co2 = 23.3494 ! Uniteless, James et al. 1992
real, parameter :: beta_clap_co2 = 3182.48  ! Kelvin, James et al. 1992

!     Coefficient for Clapeyron law for psat (psat = exp(beta/Th2o+alpha)),following Murphy and Koop 2005
real, parameter :: alpha_clap_h2o = 28.9074 ! Uniteless, Murphy and Koop 2005
real, parameter :: beta_clap_h2o = -6143.7  ! Kelvin, Murphy and Koop 2005

!     Density of the regolith (Zent et al., 1995, Buhler and Piqueux 2021)     
real, parameter :: rho_regolith = 2000. ! kg/m^3

!     Average  Thermal inertia of the surface, breccia, bedrock, following Mellon et al., 2000., Wood et al., 2008
real, parameter :: TI_regolith_avg = 250. ! Averaged of the observed thermal inertia for regolith following Mellon et al., 2000[SI]
real, parameter :: TI_breccia = 750.      ! Thermal inertia of Breccia following Wood 2009 [SI]
real, parameter :: TI_bedrock = 2300.     ! Thermal inertia of Bedrock following Wood 2009 [SI]

!     Porosity of the soil
real, parameter :: porosity = 0.4 ! porosity of the martian soil, correspond to the value for a random loose packing of monodiperse sphere (Scott, 1960)

!     Stefan Boltzmann constant
real, parameter :: sigmaB = 5.678e-8 

!     Latent heat of CO2
real, parameter :: Lco2 =  5.71e5 ! Pilorget and Forget 2016

! Conversion H2O/CO2 frost to perennial frost and vice versa
real, parameter :: threshold_h2o_frost2perennial = 1000.  !~ 1 m
real, parameter :: threshold_co2_frost2perennial = 16000. !~ 10 m

END MODULE constants_marspem_mod
