MODULE paleoclimate_mod
!=======================================================================
!   subject: Module dedicated to paleoclimates studies
!   --------
!
!   author: LL, 06/2023
!   ------
!   
!=======================================================================

    IMPLICIT NONE

    LOGICAL, SAVE :: paleoclimate    ! False by default, is activate  for paleoclimates specific processes (e.g., lag layer)
                                     ! is initialized in conf_phys
!$OMP THREADPRIVATE(paleoclimate)

    real, save, allocatable :: h2o_ice_depth(:,:)  ! Thickness of the lag before H2O ice [m]
    real, save, allocatable :: lag_co2_ice(:,:)  ! Thickness of the lag before CO2 ice [m]
    real, save :: albedo_perenialco2             ! Albedo for perenial co2 ice [1]
    real, save, allocatable :: d_coef(:,:)  ! Diffusion coeficent
    LOGICAL,SAVE :: lag_layer ! does lag layer is present?
!$OMP THREADPRIVATE(h2o_ice_depth,d_coef,lag_co2_ice,albedo_perenialco2)

    CONTAINS


  subroutine ini_paleoclimate_h(ngrid,nslope)

  implicit none
  integer,intent(in) :: ngrid  ! number of atmospheric columns
  integer,intent(in) :: nslope ! number of slope within a mesh 

    allocate(h2o_ice_depth(ngrid,nslope))
    allocate(lag_co2_ice(ngrid,nslope))
    allocate(d_coef(ngrid,nslope))
  end subroutine ini_paleoclimate_h

  subroutine end_paleoclimate_h

  implicit none
    if (allocated(d_coef)) deallocate(d_coef)
    if (allocated(h2o_ice_depth)) deallocate(h2o_ice_depth)
    if (allocated(lag_co2_ice)) deallocate(lag_co2_ice)
  end subroutine end_paleoclimate_h


    END MODULE paleoclimate_mod
