#! /usr/bin/env python

def detsize( xx, res=1, thres=3, loga=False ):
    import numpy as np
    import math
    size = []
    sizecalc = 1
    diff = np.asarray( np.roll(xx,-1) - xx )
    for i in diff:
        if abs(i) > 1:
            if sizecalc >= thres: 
                if loga: addthis = math.log(sizecalc*res)
                else:    addthis = sizecalc*res
                size.append(addthis)
            sizecalc = 1
        else:
            sizecalc += 1
    return size

def getsize(filename):

    import numpy as np
    from scipy.ndimage.measurements import minimum_position
    from netCDF4 import Dataset
    import matplotlib.pyplot as plt
    import myplot as myp
   
    ### LOAD NETCDF DATA
    filename = "psfc.nc"
    nc = Dataset(filename) 
    psfc = nc.variables["PSFC"]
    
    ### LOOP on TIME
    ### NB: a same event could be counted several times...
    shape = np.array(psfc).shape
    allsizesx = []
    allsizesy = []
    stride = 1 #5
    for i in range(0,shape[0],stride):

        psfc2d = np.array ( psfc [ i, : , : ] )
    
        ############### CRITERION
        ave = np.mean(psfc2d,dtype=np.float64)  ## dtype otherwise inaccuracy

        #limdp = -0.2 ## on en loupe pas mal
        #where = np.where(psfc2d - ave < limdp)  ## comme le papier Phoenix
    
        std = np.std(psfc2d,dtype=np.float64)   ## dtype otherwise inaccuracy
        fac = 4.   ## how many sigmas. not too low, otherwise vortices are not caught. 4 good choice.
                   ## 2.5 clearly too low, 3.5 not too bad, 4 probably good
        fac = 3.5
        #fac = 2.5
        lim = ave - fac*std
        where = np.where(psfc2d < lim)
        ############### END CRITERION
   
        lab = np.zeros(np.array(psfc2d).shape) ## points to be treated by the minimum_position routine
        lab[where] = 1.  ## do not treat points close to 'mean' (background) pressure

        draw = False
        if draw:
        ##################################################################################
            vmin = -0.3
            vmax =  0.0
            ndiv = 3
            palette = plt.get_cmap(name="YlGnBu") 
            what_I_plot = psfc2d-ave
            zevmin, zevmax = myp.calculate_bounds(what_I_plot,vmin=vmin,vmax=vmax)
            what_I_plot = myp.bounds(what_I_plot,zevmin,zevmax)
            zelevels = np.linspace(zevmin,zevmax)
            fig = plt.figure() 
            sub = myp.definesubplot(2,fig)
            plt.subplot(sub) 
            plt.contourf(what_I_plot,zelevels,cmap=palette) 
            plt.colorbar(fraction=0.05,pad=0.03,format="%.1f",\
                           ticks=np.linspace(zevmin,zevmax,ndiv+1),\
                           extend='both',spacing='proportional')
            plt.subplot(sub+1)
            palette = plt.get_cmap(name="binary")
            plt.contourf(lab,2,cmap=palette)
            plt.show() 
        ##################################################################################
  
        xx = []
        yy = []
        while 1 in lab:
            p = minimum_position(psfc2d,labels=lab)
            lab[p] = 0 ## once a minimum has been found in a grid point, do not search here again.
            if p[0] not in xx: xx.append(p[0]) ## if x coordinate not yet in the list add it
            if p[1] not in yy: yy.append(p[1]) ## if y coordinate not yet in the list add it
        xx.sort()
        yy.sort()
        ### now xx and yy are sorted arrays containing grid points with pressure minimum
       
        ######## DETERMINE SIZE OF STRUCTURES
        ######## this is rather brute-force...
        sizex = detsize( xx, res = 10, loga=False, thres=2 )
        sizey = detsize( yy, res = 10, loga=False, thres=2 )
        #sizex = detsize( xx, res = 10, loga=False, thres=3 )
        #sizey = detsize( yy, res = 10, loga=False, thres=3 )
        ###
        #if ( mym.max(sizex) > mym.max(sizey) ): sizey = sizex  ### un peu limite dans certains cas
        if (len(sizex) > len(sizey))     : sizey = sizex        ### plus fidele mais petit souci lorsque PBC
        elif (len(sizex) == len(sizey))  : 
          if ( mym.max(sizex) > mym.max(sizey) ): sizey = sizex
          else                                  : sizex = sizey
        else                            : sizex = sizey
        allsizesx = np.append(allsizesx,sizex)
        allsizesy = np.append(allsizesy,sizey)
        print i, ' on ', shape[0], ' caught ', len(sizex), ' vortices ', sizex
        ########
  
    allsizesx.sort()
    allsizesy.sort()
    
    return allsizesx, allsizesy

#########################################################################
#########################################################################

import matplotlib.pyplot as plt
import pickle
import numpy as np
import matplotlib.mlab as mlab
import mymath as mym

save = True
save = False

if save:
    allsizesx, allsizesy = getsize("psfc.nc")
    ### sauvegarde texte pour inspection
    mym.writeascii(allsizesx,'allsizex.txt')
    mym.writeascii(allsizesy,'allsizey.txt')
    ### sauvegarde binaire pour utilisation python
    myfile = open('allsizex.bin', 'wb')
    pickle.dump(allsizesx, myfile)
    myfile.close()
    myfile = open('allsizey.bin', 'wb')
    pickle.dump(allsizesy, myfile)
    myfile.close()

### load files
myfile = open('allsizex.bin', 'r')
allsizesx = pickle.load(myfile)
myfile = open('allsizey.bin', 'r')
allsizesy = pickle.load(myfile)

### append sizes
plothist = np.append(allsizesx,allsizesy)
plothist = allsizesx
#plothist = allsizesy
plothist.sort()

### make bins
nbins = 100
zebins = [2.0]
#nbins = 8
#zebins = [19.0]
#nbins = 15
#zebins = [11.] ##12 non mais donne un peu la meme chose
#zebins = [20.] ##20 non car trop pres du premier
nbins = 100
zebins = [2./np.sqrt(2.)]  ## ne pas tomber sur une dizaine ronde
nbins = 200
zebins = [0.2/np.sqrt(2.)]  ## ne pas tomber sur une dizaine ronde

for i in range(0,nbins):  zebins.append(zebins[i]*np.sqrt(2))
zebins = np.array(zebins)
### select reasonable bins for DD
zebins = zebins [ zebins > 10. ] 
zebins = zebins [ zebins < 1000. ]
#print 'bins ',zebins
print 'corrected bins ',zebins
print 'max value ',mym.max(plothist),mym.max(allsizesx),mym.max(allsizesy) 

#plothist = [20.,30.,40.,50.,70.,100.,130.,190.,260.,370.,520.]  ## pour calibrer

#### HISTOGRAM
plt.hist(    plothist,\
             log=True,\
             bins=zebins,\
#             cumulative=-1,\
        )
plt.xscale('log')
plt.show()

