MODULE nb_time_step_PCM_mod

use netcdf, only: nf90_open, NF90_NOWRITE, nf90_noerr, nf90_strerror, &
                  nf90_get_var, nf90_inq_varid, nf90_inq_dimid,       &
                  nf90_inquire_dimension, nf90_close

implicit none

character(256) :: msg, var, modname

!=======================================================================
contains
!=======================================================================

SUBROUTINE nb_time_step_PCM(fichnom,timelen)

implicit none

!=======================================================================
!
! Purpose: Read in the data_PCM_Yr*.nc the number of time step
!
! Author: RV
!=======================================================================

include "dimensions.h"

!=======================================================================
! Arguments:
character(len = *), intent(in) :: fichnom !--- FILE NAME
!=======================================================================
!   Local Variables
integer        :: iq, fID, vID, idecal, ierr
integer        :: timelen ! number of times stored in the file
!-----------------------------------------------------------------------
modname = "nb_time_step_PCM"

!  Open initial state NetCDF file
var = fichnom
call error_msg(NF90_OPEN(var,NF90_NOWRITE,fID),"open",var)

ierr = nf90_inq_varid (fID, "temps", vID)
if (ierr /= nf90_noerr) then
    write(*,*)"read_data_PCM: Le champ <temps> est absent"
    write(*,*)"read_data_PCM: J essaie <time_counter>"
    ierr = nf90_inq_varid (fID, "time_counter", vID)
    if (ierr /= nf90_noerr) then
        write(*,*)"read_data_PCM: Le champ <time_counter> est absent"
        write(*,*)"read_data_PCM: J essaie <Time>"
        ierr = nf90_inq_varid (fID, "Time", vID)
        if (ierr /= nf90_noerr) then
            write(*,*)"read_data_PCM: Le champ <Time> est absent"
            write(*,*)trim(nf90_strerror(ierr))
            call abort_gcm("nb_time_step_PCM", "", 1)
        endif
        ! Get the length of the "Time" dimension
        ierr = nf90_inq_dimid(fID,"Time",vID)
        ierr = nf90_inquire_dimension(fID,vID,len = timelen)
    else
        ! Get the length of the "time_counter" dimension
        ierr = nf90_inq_dimid(fID,"time_counter",vID)
        ierr = nf90_inquire_dimension(fID,vID,len = timelen)
    endif
else
    ! Get the length of the "temps" dimension
    ierr = nf90_inq_dimid(fID,"temps",vID)
    ierr = nf90_inquire_dimension(fID,vID,len = timelen)
endif

call error_msg(NF90_CLOSE(fID),"close",fichnom)

write(*,*) "The number of timestep of the PCM run data=", timelen

END SUBROUTINE nb_time_step_PCM

!=======================================================================

SUBROUTINE error_msg(ierr,typ,nam)

implicit none

integer,            intent(in) :: ierr !--- NetCDF ERROR CODE
character(len = *), intent(in) :: typ  !--- TYPE OF OPERATION
character(len = *), intent(in) :: nam  !--- FIELD/FILE NAME

if (ierr == nf90_noerr) return
select case(typ)
    case('inq');   msg = "Field <"//trim(nam)//"> is missing"
    case('get');   msg = "Reading failed for <"//trim(nam)//">"
    case('open');  msg = "File opening failed for <"//trim(nam)//">"
    case('close'); msg = "File closing failed for <"//trim(nam)//">"
    case default
        write(*,*) 'There is no message for this error.'
        error stop
end select
call abort_gcm(trim(modname),trim(msg),ierr)

END SUBROUTINE error_msg

END MODULE nb_time_step_PCM_mod
