MODULE info_PEM_mod

implicit none

!=======================================================================
contains
!=======================================================================

SUBROUTINE info_PEM(year_iter,criterion_stop,i_myear,n_myear)

!=======================================================================
!
! Purpose: Update the first line of "info_PEM.txt" to count the number of simulated Martian years
!          Write in "info_PEM.txt" the reason why the PEM stopped and the number of simulated years
!
! Author: RV, JBC
!=======================================================================

use time_evol_mod, only: convert_years

implicit none

!----- Arguments
integer, intent(in) :: year_iter, criterion_stop ! # of year and reason to stop
integer, intent(in) :: i_myear, n_myear          ! Current simulated Martian year and maximum number of Martian years to be simulated

!----- Local variables
logical       :: ok
integer       :: cstat
character(10) :: ich1, ich2, fch

!----- Code
inquire(file = 'info_PEM.txt', exist = ok)
if (ok) then
    write(ich1,'(i0)') i_myear
    write(ich2,'(i0)') n_myear
    write(fch,'(f0.4)') convert_years ! 4 digits afetr to the right of the decimal point to respect the precision of Martian year in "launch_pem.sh"
    call execute_command_line('sed -i "1s/.*/'//trim(ich1)//' '//trim(ich2)//' '//trim(fch)//'/" info_PEM.txt',cmdstat = cstat)
    if (cstat > 0) then
        error stop 'info_PEM: command exection failed!'
    else if (cstat < 0) then
        error stop 'info_PEM: command execution not supported!'
    endif
    open(1,file = 'info_PEM.txt',status = "old",position = "append",action = "write")
    write(1,*) year_iter, i_myear, criterion_stop
    close(1)
else
    error stop 'The file ''info_PEM.txt'' does not exist and cannot be updated!'
endif

END SUBROUTINE info_PEM

END MODULE info_PEM_mod
