MODULE comcstfi_h
IMPLICIT NONE

REAL,PARAMETER :: pi=acos(-1.d0) ! something like 3.14159
REAL,SAVE :: rad ! radius of the planet (m)
REAL,SAVE :: g ! gravity (m/s2)
!$OMP THREADPRIVATE(rad,g)
REAL,SAVE :: r ! reduced gas constant (r=8.314511/(mugaz/1000.0))
REAL,SAVE :: cpp ! Cp of the atmosphere
REAL,SAVE :: rcp ! r/cpp
!$OMP THREADPRIVATE(r,cpp,rcp)
REAL,SAVE :: mugaz ! molar mass of the atmosphere (g/mol)
REAL,SAVE :: omeg ! planet rotation rate (rad/s)
!$OMP THREADPRIVATE(mugaz,omeg)

! NB: Ideally all module variables should be "protected"...

CONTAINS

SUBROUTINE init_comcstfi_h(prad,pcpp,pg,pr)
IMPLICIT NONE

REAL,INTENT(IN) :: prad
REAL,INTENT(IN) :: pcpp
REAL,INTENT(IN) :: pg
REAL,INTENT(IN) :: pr

  rad=prad
  cpp=pcpp
  g=pg
  r=pr
  rcp=r/cpp

END SUBROUTINE init_comcstfi_h

END MODULE comcstfi_h
