      MODULE planete_h
      IMPLICIT NONE

      REAL,SAVE :: aphelie   ! Aphelion, in Mkm
      REAL,SAVE :: periheli  ! Perihelion, in Mkm
      REAL,SAVE :: year_day  ! Number of days in the year
!$OMP THREADPRIVATE(aphelie,periheli,year_day)
      REAL,SAVE :: peri_day  ! Date of perihelion, in days
      REAL,SAVE :: obliquit  ! Obliquity of the planet, in degrees
      REAL,SAVE :: lmixmin
!$OMP THREADPRIVATE(peri_day,obliquit,lmixmin)
      REAL,SAVE :: emin_turb
      REAL,SAVE :: coefvis
      REAL,SAVE :: coefir
!$OMP THREADPRIVATE(emin_turb,coefvis,coefir)
      REAL,SAVE :: lsperi    ! Solar longitude of the perihelion, angle in rad
      REAL,SAVE :: e_elips   ! Orbit eccentricity
      REAL,SAVE :: p_elips   ! Ellipse semi-latus rectum
      REAL,SAVE :: unitastr  ! Astronomical unit AU, in Mkm
!$OMP THREADPRIVATE(lsperi,e_elips,p_elips,unitastr)

      END MODULE planete_h
