MODULE write_output_mod

IMPLICIT NONE

PRIVATE

INTERFACE write_output
    MODULE PROCEDURE write_output_d0, write_output_d1, write_output_d2, &
                     write_output_i0, write_output_i1, write_output_i2, &
                     write_output_l0, write_output_l1, write_output_l2
END INTERFACE write_output

PUBLIC write_output

!----------------------------------------------------------------------
CONTAINS
!----------------------------------------------------------------------

  SUBROUTINE write_output_d0(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field

  call writediagfi(ngrid,field_name,title,units,0,field)
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field)
  endif
#endif

  END SUBROUTINE write_output_d0

!----------------------------------------------------------------------

  SUBROUTINE write_output_d1(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field(:)

  call writediagfi(ngrid,field_name,title,units,2,field)
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field)
  endif
#endif

  END SUBROUTINE write_output_d1

!----------------------------------------------------------------------

  SUBROUTINE write_output_d2(field_name,title,units,field)
  ! For a "3D" horizontal-vertical field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  REAL,INTENT(IN)                :: field(:,:)

  if(size(field(:,:),2).eq.nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,field)
  else
    call writediagfi(ngrid,field_name,title,units,3,field(:,:))
  endif
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field)
  endif
#endif

  END SUBROUTINE write_output_d2

!----------------------------------------------------------------------

  SUBROUTINE write_output_i0(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  INTEGER,INTENT(IN)             :: field

  call writediagfi(ngrid,field_name,title,units,0,real(field))
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,real(field))
  endif
#endif

  END SUBROUTINE write_output_i0

!----------------------------------------------------------------------

  SUBROUTINE write_output_i1(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  INTEGER,INTENT(IN)             :: field(:)

  call writediagfi(ngrid,field_name,title,units,2,real(field))
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,real(field))
  endif
#endif

  END SUBROUTINE write_output_i1

!----------------------------------------------------------------------

  SUBROUTINE write_output_i2(field_name,title,units,field)
  ! For a "3D" horizontal-vertical field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  INTEGER,INTENT(IN)             :: field(:,:)

  if(size(field(:,:),2).eq.nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,real(field))
  else
    call writediagfi(ngrid,field_name,title,units,3,real(field(:,:)))
  endif
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,real(field))
  endif
#endif

  END SUBROUTINE write_output_i2

!----------------------------------------------------------------------

  SUBROUTINE write_output_l0(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  LOGICAL,INTENT(IN)             :: field
! Local argument used to convert logical to real
  REAL                           :: field_real

  field_real=0
  if(field) field_real=1

  call writediagfi(ngrid,field_name,title,units,0,field_real)
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field_real)
  endif
#endif

  END SUBROUTINE write_output_l0

!----------------------------------------------------------------------

  SUBROUTINE write_output_l1(field_name,title,units,field)
  ! For a surface field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  LOGICAL,INTENT(IN)             :: field(:)
! Local argument used to convert logical to real
  REAL                           :: field_real(ngrid)
  INTEGER                        :: i

  field_real(:)=0.
  DO i=1,ngrid
    if(field(i)) field_real(i)=1.
  ENDDO

  call writediagfi(ngrid,field_name,title,units,2,field_real(:))
#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field_real)
  endif
#endif

  END SUBROUTINE write_output_l1

!----------------------------------------------------------------------

  SUBROUTINE write_output_l2(field_name,title,units,field)
  ! For a "3D" horizontal-vertical field
#ifdef CPP_XIOS
  use xios_output_mod, only: xios_is_active_field
  use xios_output_mod, only: send_xios_field
#endif
  use comsoil_h, only: nsoilmx
  use writediagsoil_mod, only: writediagsoil
  IMPLICIT NONE
  include "dimensions.h"
  INTEGER ngrid
  PARAMETER( ngrid = 2+(jjm-1)*iim - 1/jjm   )
  CHARACTER(LEN=*),INTENT(IN)    :: field_name
  CHARACTER(LEN=*),INTENT(IN)    :: title
  CHARACTER(LEN=*),INTENT(IN)    :: units
  LOGICAL,INTENT(IN)             :: field(:,:)
! Local argument used to convert logical to real
  REAL,allocatable               :: field_real(:,:)
  INTEGER                        :: i,j

  allocate(field_real(size(field,1),size(field,2)))

  field_real(:,:)=0.
  DO i=1,size(field,1)
    DO j=1,size(field,2)
      if(field(i,j)) field_real(i,j)=1.
    ENDDO
  ENDDO

  if(size(field(:,:),2).eq.nsoilmx) then
    call writediagsoil(ngrid,field_name,title,units,3,field_real)
  else
    call writediagfi(ngrid,field_name,title,units,3,field_real(:,:))
  endif

#ifdef CPP_XIOS
  if (xios_is_active_field(field_name)) then
    ! only send the field to xios if the user asked for it
    call send_xios_field(field_name,field_real)
  endif
#endif

  deallocate(field_real)

  END SUBROUTINE write_output_l2

END MODULE write_output_mod
