MODULE info_run_PEM_mod

implicit none

!=======================================================================
contains
!=======================================================================

SUBROUTINE info_run_PEM(year_iter,criterion_stop,i_myear,n_myear)

!=======================================================================
!
! Purpose: Write in a file called info_run_PEM.txt the reason why the PEM did stop and the number of extrapolation year done
!          Update the file tmp_PEMyears.txt to count the number of simulated Martian years
!
! Author: RV, JBC
!=======================================================================

use time_evol_mod, only: convert_years

implicit none

!----- Arguments
integer, intent(in) :: year_iter, criterion_stop ! # of year and reason to stop
integer, intent(in) :: i_myear, n_myear          ! Current simulated Martian year and maximum number of Martian years to be simulated

!----- Local variables
logical :: ok

!----- Code
inquire(file = 'info_run_PEM.txt', exist = ok)
if (ok) then
    open(12,file = 'info_run_PEM.txt',status = "old",position = "append",action = "write")
else
    open(12,file = 'info_run_PEM.txt',status = "new",action = "write")
endif
write(12,*) year_iter, i_myear, criterion_stop
close(12)

open(100,file = 'tmp_PEMyears.txt',status = 'replace')
write(100,*) i_myear, n_myear, convert_years
close(100)

END SUBROUTINE info_run_PEM

END MODULE info_run_PEM_mod
