SUBROUTINE compute_tendencies_slope(ngrid,nslope,min_ice_Y1,min_ice_Y2,tendencies_ice)

implicit none

!=======================================================================
!
!  Compute the tendencies of the evolution of water ice over the years
!
!=======================================================================

!   arguments:
!   ----------
!   INPUT
integer,                       intent(in) :: ngrid, nslope ! # of grid points along longitude/latitude/ total
real, dimension(ngrid,nslope), intent(in) :: min_ice_Y1    ! LON x LAT field : minimum of water ice at each point for the first year
real, dimension(ngrid,nslope), intent(in) :: min_ice_Y2    ! LON x LAT field : minimum of water ice at each point for the second year

!   OUTPUT
real, dimension(ngrid,nslope), intent(out) :: tendencies_ice ! physical point field : difference between the minima = evolution of perenial ice

!=======================================================================

!  We compute the difference
tendencies_ice = min_ice_Y2 - min_ice_Y1

!  If the difference is too small; there is no evolution
where (abs(tendencies_ice) < 1.e-10) tendencies_ice = 0.

END SUBROUTINE compute_tendencies_slope

