SUBROUTINE writerestart1D(filename,psurf,tsurf,nlayer,temp,u,v,nq,qnames,qsurf,q)

implicit none

! Arguments
character(len = *),                intent(in) :: filename
integer,                           intent(in) :: nlayer, nq
real,                              intent(in) :: psurf, tsurf
real, dimension(nlayer),           intent(in) :: temp, u, v
real, dimension(nlayer,nq),        intent(in) :: q
real, dimension(nq),               intent(in) :: qsurf
character(len = *), dimension(nq), intent(in) :: qnames

! Local variables
integer :: il, iq

! Write the data needed for a restart in "restart1D.txt"
open(1,file = filename,status = "replace",action = "write")
do iq = 1,nq
    write(1,*) qnames(iq), qsurf(iq), (q(il,iq), il = 1,nlayer)
enddo
write(1,*) 'ps', psurf
write(1,*) 'u', (u(il), il = 1,nlayer)
write(1,*) 'v', (v(il), il = 1,nlayer)
write(1,*) 'teta', tsurf, (temp(il), il = 1,nlayer)
close(1)

END SUBROUTINE writerestart1D
