!
! $Id $
!
SUBROUTINE nb_time_step_GCM(fichnom,timelen)

      use netcdf, only: nf90_open,NF90_NOWRITE,nf90_noerr,nf90_strerror, &
                        nf90_get_var, nf90_inq_varid, nf90_inq_dimid, &
                        nf90_inquire_dimension,nf90_close

      IMPLICIT NONE

!=======================================================================
!
! Purpose: Read in the data_GCM_Yr*.nc the number of time step
!
! Author: RV
!=======================================================================

  include "dimensions.h"

!===============================================================================
! Arguments:
  CHARACTER(LEN=*), INTENT(IN) :: fichnom          !--- FILE NAME
!===============================================================================
!   Local Variables 
  CHARACTER(LEN=256) :: msg, var, modname
  INTEGER :: iq, fID, vID, idecal
  INTEGER :: ierr

  INTEGER :: timelen ! number of times stored in the file
!-----------------------------------------------------------------------
  modname="nb_time_step_GCM"

!  Open initial state NetCDF file
  var=fichnom
  CALL err(NF90_OPEN(var,NF90_NOWRITE,fID),"open",var)

      ierr = nf90_inq_varid (fID, "temps", vID)
      IF (ierr .NE. nf90_noerr) THEN
        write(*,*)"read_data_GCM: Le champ <temps> est absent"
        write(*,*)"read_data_GCM: J essaie <time_counter>"
        ierr = nf90_inq_varid (fID, "time_counter", vID)
        IF (ierr .NE. nf90_noerr) THEN
          write(*,*)"read_data_GCM: Le champ <time_counter> est absent"
          write(*,*)"read_data_GCM: J essaie <Time>"
          ierr = nf90_inq_varid (fID, "Time", vID)
          IF (ierr .NE. nf90_noerr) THEN
            write(*,*)"read_data_GCM: Le champ <Time> est absent"
            write(*,*)trim(nf90_strerror(ierr))
            CALL ABORT_gcm("nb_time_step_GCM", "", 1)
          ENDIF
          ! Get the length of the "Time" dimension
          ierr = nf90_inq_dimid(fID,"Time",vID)
          ierr = nf90_inquire_dimension(fID,vID,len=timelen)          
        ELSE
        ! Get the length of the "time_counter" dimension
        ierr = nf90_inq_dimid(fID,"time_counter",vID)
        ierr = nf90_inquire_dimension(fID,vID,len=timelen)
        ENDIF
      ELSE   
        ! Get the length of the "temps" dimension
        ierr = nf90_inq_dimid(fID,"temps",vID)
        ierr = nf90_inquire_dimension(fID,vID,len=timelen)
      ENDIF

  CALL err(NF90_CLOSE(fID),"close",fichnom)

  write(*,*) "The number of timestep of the PCM run data=", timelen

  CONTAINS

SUBROUTINE err(ierr,typ,nam)
  INTEGER,          INTENT(IN) :: ierr   !--- NetCDF ERROR CODE
  CHARACTER(LEN=*), INTENT(IN) :: typ    !--- TYPE OF OPERATION
  CHARACTER(LEN=*), INTENT(IN) :: nam    !--- FIELD/FILE NAME
  IF(ierr==NF90_NoERR) RETURN
  SELECT CASE(typ)
    CASE('inq');   msg="Field <"//TRIM(nam)//"> is missing"
    CASE('get');   msg="Reading failed for <"//TRIM(nam)//">"
    CASE('open');  msg="File opening failed for <"//TRIM(nam)//">"
    CASE('close'); msg="File closing failed for <"//TRIM(nam)//">"
  END SELECT
  CALL ABORT_gcm(TRIM(modname),TRIM(msg),ierr)
END SUBROUTINE err

END SUBROUTINE nb_time_step_GCM
