      module radinc_h

      implicit none

#include "dimensions.h"
#include "bands.h"

!======================================================================C
!
!     RADINC.H    RADiation INCludes
!
!     Includes for the radiation code; RADIATION LAYERS, LEVELS,
!     number of spectral intervals. . .
! 
!======================================================================C

!     RADIATION parameters

!     In radiation code, layer 1 corresponds to the stratosphere.  Level
!     1 is the top of the stratosphere.  The dummy layer is at the same
!     temperature as the (vertically isothermal) stratosphere, and
!     any time it is explicitly needed, the appropriate quantities will
!     be dealt with (aka "top". . .)

!     L_NLEVRAD corresponds to the surface - i.e., the GCM Level that
!     is at the surface.  PLEV(L_NLEVRAD) = P(J,I)+PTROP, 
!     PLEV(2) = PTROP, PLEV(1) = ptop

!     L_NLAYRAD is the number of radiation code layers
!     L_NLEVRAD is the number of radiation code levels.  Level N is the
!               top of layer N. 
!
!     L_NSPECTI is the number of IR spectral intervals
!     L_NSPECTV is the number of Visual(or Solar) spectral intervals
!     L_NGAUSS  is the number of Gauss points for K-coefficients
!               GAUSS POINT 17 (aka the last one) is the special case
!
!     L_NPREF   is the number of reference pressures that the 
!               k-coefficients are calculated on
!     L_PINT    is the number of Lagrange interpolated reference
!               pressures for the gas k-coefficients - now for a
!		smaller p-grid than before
!     L_NTREF   is the number of reference temperatures for the
!               k-coefficients
!     L_TAUMAX  is the largest optical depth - larger ones are set
!               to this value
!
!     L_REFVAR  The number of different mixing ratio values for
!               the k-coefficients. Variable component of the mixture
!		can in princple be anything: currently it's H2O.
!
!     NAERKIND  The number of radiatively active aerosol types
!
!     NSIZEMAX  The maximum number of aerosol particle sizes
!
!----------------------------------------------------------------------C

      integer, parameter :: L_NLAYRAD  = llm
      integer, parameter :: L_LEVELS   = 2*(llm-1)+3
      integer, parameter :: L_NLEVRAD  = llm+1

!     Below are various parameter combinations that will work for the 
!     radiative datasets indicated. For the moment, you must change these
!     values manually before compiling, each time you want to change the
!     dataset.
 
      integer, parameter :: L_NGAUSS  = 17

      integer, parameter :: L_NPREF   = 9
      integer, parameter :: L_NTREF   = 7
      integer, parameter :: L_REFVAR  = 7   ! earth / earlymars
      ! CO2_H2Ovar / N2OCO2rich_H2Ovar / N2OCO2poor_H2Ovar
!       integer, parameter :: L_REFVAR = 4    ! N2_CH4

!      integer, parameter :: L_NPREF   = 8
!      integer, parameter :: L_NTREF   = 11
!      integer, parameter :: L_REFVAR  = 8   ! N2_H2Ovar

!      integer, parameter :: L_NPREF   = 8
!      integer, parameter :: L_NTREF   = 5
!      integer, parameter :: L_REFVAR  = 1   ! therm_test2

!      integer, parameter :: L_NPREF   = 12
!      integer, parameter :: L_NTREF   = 20
!      integer, parameter :: L_REFVAR  = 1   ! null (for H2 etc.)

!      integer, parameter :: L_NPREF   = 10
!      integer, parameter :: L_NTREF   = 5
!      integer, parameter :: L_REFVAR  = 7   ! N2_CO2var

!      integer, parameter :: L_NPREF   = 8
!      integer, parameter :: L_NTREF   = 6
!      integer, parameter :: L_REFVAR  = 1   ! pureCO2

!      integer, parameter :: L_NPREF   = 7
!      integer, parameter :: L_NTREF   = 5
!      integer, parameter :: L_REFVAR  = 1   ! degraded_pure

!      integer, parameter :: L_NPREF   = 9
!      integer, parameter :: L_NTREF   = 14
!      integer, parameter :: L_REFVAR  = 1   ! megaCO2

      integer, parameter :: L_NSPECTI = NBinfrared
      integer, parameter :: L_NSPECTV = NBvisible

      integer, parameter :: L_PINT    = (L_NPREF-1)*5+1
      integer, parameter :: NAERKIND  = 2
      real,    parameter :: L_TAUMAX  = 35
      !integer, parameter :: L_TAUMAX  = 35
      !integer, parameter :: L_TAUMAX  = 40

      ! For Planck function integration: 
      ! equivalent temperatures are 1/10 of these values
      integer, parameter :: NTstar = 500
      integer, parameter :: NTstop = 9000 ! new default for all non hot Jupiter runs
      !integer, parameter :: NTstop = 6000 ! for GJ581d / earlymars runs

! Maximum number of grain size classes
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   This parameter has to be set to the maximum number of particle
!   sizes contained in the optical parameter database; For example,
!   if only one grain size is used to describe dust, and 30 are used
!   to describe water-ice crystals in the visible and 15 in the IR,
!   nsizemax has to be set to 30.
!   If only one grain size is considered for all the aerosols, set
!   this parameter to 1 and convolution will be turned off during
!   the radiative calculations.

      integer, parameter :: nsizemax = 60
!      integer, parameter :: nsizemax = 1

      character (len=20) :: corrkdir
      save corrkdir

      character (len=30) :: banddir
      save banddir

      end module radinc_h
