      subroutine optci(PLEV,TLEV,DTAUI,TAUCUMI,      &
           QXIAER,QSIAER,GIAER,COSBI,WBARI,TAUAERO,  &
           TMID,PMID,TAUGSURF,QVAR,MUVAR)

      use radinc_h
      use radcommon_h, only: gasi, tlimit, wrefVAR, Cmk,tgasref,pfgasref,wnoi,scalep
      implicit none

!==================================================================
!     
!     Purpose
!     -------
!     Calculates longwave optical constants at each level. For each
!     layer and spectral interval in the IR it calculates WBAR, DTAU
!     and COSBAR. For each level it calculates TAU.
!     
!     TAUI(L,LW) is the cumulative optical depth at level L (or alternatively
!     at the *bottom* of layer L), LW is the spectral wavelength interval.
!     
!     TLEV(L) - Temperature at the layer boundary (i.e., level)
!     PLEV(L) - Pressure at the layer boundary (i.e., level)
!
!     Authors
!     -------
!     Adapted from the NASA Ames code by R. Wordsworth (2009)
!     
!==================================================================


#include "comcstfi.h"
#include "callkeys.h"
#include "gases.h"


      real*8 DTAUI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)
      real*8 DTAUKI(L_LEVELS+1,L_NSPECTI,L_NGAUSS)
      real*8 TAUI(L_NLEVRAD,L_NSPECTI,L_NGAUSS)
      real*8 TAUCUMI(L_LEVELS,L_NSPECTI,L_NGAUSS)
      real*8 PLEV(L_LEVELS)
      real*8 TLEV(L_LEVELS)
      real*8 TMID(L_LEVELS), PMID(L_LEVELS)
      real*8 COSBI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)
      real*8 WBARI(L_NLAYRAD,L_NSPECTI,L_NGAUSS)

!     For aerosols
      real*8  QXIAER(L_LEVELS+1,L_NSPECTI,NAERKIND)
      real*8  QSIAER(L_LEVELS+1,L_NSPECTI,NAERKIND)
      real*8  GIAER(L_LEVELS+1,L_NSPECTI,NAERKIND)
      real*8  TAUAERO(L_LEVELS+1,NAERKIND)
      real*8  TAUAEROLK(L_LEVELS+1,L_NSPECTI,NAERKIND)
      real*8  TAEROS(L_LEVELS,L_NSPECTI,NAERKIND)

      integer L, NW, NG, K, LK, IAER
      integer MT(L_LEVELS), MP(L_LEVELS), NP(L_LEVELS)
      real*8  ANS, TAUGAS
      real*8  DPR(L_LEVELS), U(L_LEVELS)
      real*8  LCOEF(4), LKCOEF(L_LEVELS,4)

      real*8 taugsurf(L_NSPECTI,L_NGAUSS-1)
      real*8 DCONT
      double precision wn_cont, p_cont, p_air, T_cont, dtemp

!     Variable species mixing ratio variables
      real*8  QVAR(L_LEVELS), WRATIO(L_LEVELS), MUVAR(L_LEVELS)
      real*8  KCOEF(4)
      integer NVAR(L_LEVELS)

!     temporary variables for multiple aerosol calculation
      real*8 atemp, btemp

!     variables for k in units m^-1
      real*8 rho, dz(L_LEVELS)

      integer igas

      !--- Kasting's CIA ----------------------------------------
      !real*8, parameter :: Ci(L_NSPECTI)=[                         &
      !     3.8E-5, 1.2E-5, 2.8E-6, 7.6E-7, 4.5E-7, 2.3E-7,    &
      !     5.4E-7, 1.6E-6, 0.0,                               &
      !     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,            & 
      !     0.0, 4.0E-7, 4.0E-6, 1.4E-5,    &
      !     1.0E-5, 1.2E-6, 2.0E-7, 5.0E-8, 3.0E-8, 0.0 ] 
      !real*8, parameter :: Ti(L_NSPECTI)=[ -2.2, -1.9,             &
      !     -1.7, -1.7, -1.7, -1.7, -1.7, -1.7,                &
      !     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
      !     -1.7,-1.7,-1.7,-1.7,-1.7,-1.7,-1.7, -1.7,0.0 ]
      !----------------------------------------------------------

!=======================================================================
!     Determine the total gas opacity throughout the column, for each
!     spectral interval, NW, and each Gauss point, NG.

      taugsurf(:,:) = 0.0
      dpr(:)        = 0.0
      lkcoef(:,:)   = 0.0

      do K=2,L_LEVELS
         DPR(k) = PLEV(K)-PLEV(K-1)

         !--- Kasting's CIA ----------------------------------------
         !dz(k)=dpr(k)*189.02*TMID(K)/(0.03720*PMID(K))
         ! this is CO2 path length (in cm) as written by Francois
         ! delta_z = delta_p * R_specific * T / (g * P)
         ! But Kasting states that W is in units of _atmosphere_ cm
         ! So we do
         !dz(k)=dz(k)*(PMID(K)/1013.25)
         !dz(k)=dz(k)/100.0 ! in m for SI calc
         !----------------------------------------------------------

         ! if we have continuum opacities, we need dz
         if(kastprof)then
            dz(k) = dpr(k)*(8314.5/muvar(k))*TMID(K)/(g*PMID(K))
            U(k)  = (Cmk*mugaz/(muvar(k)))*DPR(k) 
         else
            dz(k) = dpr(k)*R*TMID(K)/(g*PMID(K))
            U(k)  = Cmk*DPR(k)    ! only Cmk line in optci.F
         endif

         call tpindex(PMID(K),TMID(K),QVAR(K),pfgasref,tgasref,WREFVAR, &
              LCOEF,MT(K),MP(K),NVAR(K),WRATIO(K))
         
         do LK=1,4
            LKCOEF(K,LK) = LCOEF(LK)
         end do


         DO NW=1,L_NSPECTI
            do iaer=1,naerkind
               TAEROS(K,NW,IAER) = TAUAERO(K,IAER) * QXIAER(K,NW,IAER)
            end do
         END DO
      end do                    ! levels

      do K=2,L_LEVELS
         do nw=1,L_NSPECTI
 
            DCONT = 0.0 ! continuum absorption

            ! include continua if necessary
            wn_cont = dble(wnoi(nw))
            T_cont  = dble(TMID(k))
            do igas=1,ngasmx

               if(gfrac(igas).eq.-1)then ! variable
                  p_cont  = dble(PMID(k)*scalep*QVAR(k)) ! qvar = mol/mol
               else
                  p_cont  = dble(PMID(k)*scalep*gfrac(igas)*(1.-QVAR(k)))
               endif

               dtemp=0.0
               if(gnom(igas).eq.'H2_')then
                  call interpolateH2H2(wn_cont,T_cont,p_cont,dtemp,.false.)
               elseif(gnom(igas).eq.'H2O'.and.T_cont.gt.200.0)then
                  p_air = dble(PMID(k)*scalep) - p_cont ! note assumes air!!
                  call interpolateH2Ocont(wn_cont,T_cont,p_cont,p_air,dtemp,.false.)

               endif

               DCONT = DCONT + dtemp

            enddo


            DCONT = DCONT*dz(k) 

            !--- Kasting's CIA ----------------------------------------
            !DCO2   = dz(k)*Ci(nw)*(1.2859*PMID(k)/1000.0)*(TMID(k)/300.)**Ti(nw)
            !DCO2 = 130*Ci(nw)*(pmid(k)/1013.25)**2*(tmid(k)/300.)**Ti(nw) * dz(k)
            ! these two have been verified to give the same results
            !----------------------------------------------------------


            do ng=1,L_NGAUSS-1

!     Now compute TAUGAS

!     Interpolate between water mixing ratios
!     WRATIO = 0.0 if the requested water amount is equal to, or outside the
!     the water data range

               if(L_REFVAR.eq.1)then ! added by RW for special no variable case
                  KCOEF(1) = GASI(MT(K),MP(K),1,NW,NG)
                  KCOEF(2) = GASI(MT(K),MP(K)+1,1,NW,NG)
                  KCOEF(3) = GASI(MT(K)+1,MP(K)+1,1,NW,NG)
                  KCOEF(4) = GASI(MT(K)+1,MP(K),1,NW,NG)
               else

                  KCOEF(1) = GASI(MT(K),MP(K),NVAR(K),NW,NG) + WRATIO(K)*     &
                       (GASI(MT(K),MP(K),NVAR(K)+1,NW,NG) -                   & 
                       GASI(MT(K),MP(K),NVAR(K),NW,NG))

                  KCOEF(2) = GASI(MT(K),MP(K)+1,NVAR(K),NW,NG) + WRATIO(K)*   &
                       (GASI(MT(K),MP(K)+1,NVAR(K)+1,NW,NG) -                 &
                       GASI(MT(K),MP(K)+1,NVAR(K),NW,NG))

                  KCOEF(3) = GASI(MT(K)+1,MP(K)+1,NVAR(K),NW,NG) + WRATIO(K)* &
                       (GASI(MT(K)+1,MP(K)+1,NVAR(K)+1,NW,NG) -               &
                       GASI(MT(K)+1,MP(K)+1,NVAR(K),NW,NG))

                  KCOEF(4) = GASI(MT(K)+1,MP(K),NVAR(K),NW,NG) + WRATIO(K)*   &
                       (GASI(MT(K)+1,MP(K),NVAR(K)+1,NW,NG) -                 &
                       GASI(MT(K)+1,MP(K),NVAR(K),NW,NG))
               endif

!     Interpolate the gaseous k-coefficients to the requested T,P values

               ANS = LKCOEF(K,1)*KCOEF(1) + LKCOEF(K,2)*KCOEF(2) +            &
                    LKCOEF(K,3)*KCOEF(3) + LKCOEF(K,4)*KCOEF(4)
               
               TAUGAS  = U(k)*ANS

               if(graybody)then
                  TAUGAS = 0.0
                  DCONT  = U(k)*3.3e-26
               endif

               TAUGSURF(NW,NG) = TAUGSURF(NW,NG) + TAUGAS + DCONT
               !TAUGSURF(NW,NG) = TAUGSURF(NW,NG) + TAUGAS

               DTAUKI(K,nw,ng) = TAUGAS + DCONT ! For parameterized continuum absorption

               do iaer=1,naerkind
                  DTAUKI(K,nw,ng) = DTAUKI(K,nw,ng) + TAEROS(K,NW,IAER)
               end do ! a bug was here!

            end do

!     Now fill in the "clear" part of the spectrum (NG = L_NGAUSS),
!     which holds continuum opacity only

            NG              = L_NGAUSS
            DTAUKI(K,nw,ng) = 0.0 + DCONT ! For parameterized continuum absorption

            do iaer=1,naerkind
               DTAUKI(K,nw,ng) = DTAUKI(K,nw,ng) +  TAEROS(K,NW,IAER)
            end do ! a bug was here!

         end do
      end do


!=======================================================================
!     Now the full treatment for the layers, where besides the opacity
!     we need to calculate the scattering albedo and asymmetry factors

      DO NW=1,L_NSPECTI
         DO K=2,L_LEVELS+1
            do iaer=1,naerkind
               TAUAEROLK(K,NW,IAER) = TAUAERO(K,IAER)*QSIAER(K,NW,IAER)
            end do
         ENDDO
      ENDDO

      DO NW=1,L_NSPECTI
         NG = L_NGAUSS
         DO L=1,L_NLAYRAD

            K              = 2*L+1
            DTAUI(L,nw,ng) = DTAUKI(K,NW,NG) + DTAUKI(K+1,NW,NG)! + 1.e-50

            atemp = 0.
            btemp = 0.
            if(DTAUI(L,NW,NG) .GT. 1.0E-9) then
               do iaer=1,naerkind
                  atemp = atemp +                                     &
                      GIAER(K,NW,IAER)   * TAUAEROLK(K,NW,IAER) +    &
                      GIAER(K+1,NW,IAER) * TAUAEROLK(K+1,NW,IAER)
                  btemp = btemp + TAUAEROLK(K,NW,IAER) + TAUAEROLK(K+1,NW,IAER)
!     *                    + 1.e-10
               end do
               WBARI(L,nw,ng) = btemp  / DTAUI(L,NW,NG)
            else
               WBARI(L,nw,ng) = 0.0D0
               DTAUI(L,NW,NG) = 1.0E-9
            endif

            if(btemp .GT. 0.0) then
               cosbi(L,NW,NG) = atemp/btemp
            else
               cosbi(L,NW,NG) = 0.0D0
            end if

         END DO ! L vertical loop

!     Now the other Gauss points, if needed.

         DO NG=1,L_NGAUSS-1
            IF(TAUGSURF(NW,NG) .gt. TLIMIT) THEN

               DO L=1,L_NLAYRAD
                  K              = 2*L+1
                  DTAUI(L,nw,ng) = DTAUKI(K,NW,NG)+DTAUKI(K+1,NW,NG)! + 1.e-50

                  btemp = 0.
                  if(DTAUI(L,NW,NG) .GT. 1.0E-9) then

                     do iaer=1,naerkind
                        btemp = btemp + TAUAEROLK(K,NW,IAER) + TAUAEROLK(K+1,NW,IAER)
                     end do
                     WBARI(L,nw,ng) = btemp  / DTAUI(L,NW,NG)

                  else
                     WBARI(L,nw,ng) = 0.0D0
                     DTAUI(L,NW,NG) = 1.0E-9
                  endif

                  cosbi(L,NW,NG) = cosbi(L,NW,L_NGAUSS)
               END DO ! L vertical loop
            END IF
            
         END DO                 ! NG Gauss loop
      END DO                    ! NW spectral loop

!     Total extinction optical depths

      DO NW=1,L_NSPECTI       
         DO NG=1,L_NGAUSS       ! full gauss loop
            TAUI(1,NW,NG)=0.0D0
            DO L=1,L_NLAYRAD
               TAUI(L+1,NW,NG)=TAUI(L,NW,NG)+DTAUI(L,NW,NG)
            END DO

            TAUCUMI(1,NW,NG)=0.0D0
            DO K=2,L_LEVELS
               TAUCUMI(K,NW,NG)=TAUCUMI(K-1,NW,NG)+DTAUKI(K,NW,NG)
            END DO
         END DO                 ! end full gauss loop
      END DO

      return


    end subroutine optci



