!
! $Id $
!
SUBROUTINE compute_tendencies_slope(ngrid,nslope,min_ice_Y1,&
     min_ice_Y2,tendencies_ice)

      IMPLICIT NONE

!=======================================================================
!
!  Compute the tendencies of the evolution of water ice over the years
!
!=======================================================================

!   arguments:
!   ----------

!   INPUT

     INTEGER, intent(in) :: ngrid, nslope                           ! # of grid points along longitude/latitude/ total
     REAL, intent(in) , dimension(ngrid,nslope):: min_ice_Y1       ! LON x LAT field : minimum of water ice at each point for the first year
     REAL, intent(in) , dimension(ngrid,nslope):: min_ice_Y2       ! LON x LAT field : minimum of water ice at each point for the second year

!   OUTPUT
     REAL, intent(out) , dimension(ngrid,nslope)   :: tendencies_ice            ! physical point field : difference between the minima = evolution of perenial ice

!   local:
!   ------
     INTEGER :: ig,islope                                                           ! loop variable

!=======================================================================

!  We compute the difference

  DO ig=1,ngrid
    DO islope = 1, nslope
      tendencies_ice(ig,islope)=min_ice_Y2(ig,islope)-min_ice_Y1(ig,islope)
    enddo
  ENDDO

!  If the difference is too small; there is no evolution
  DO ig=1,ngrid
    DO islope = 1, nslope
      if(abs(tendencies_ice(ig,islope)).LT.1.0E-10) then
        tendencies_ice(ig,islope)=0.
      endif
    enddo
  ENDDO

END SUBROUTINE compute_tendencies_slope

