module lask_param_mod
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!
!!! Purpose: Define parameters from Laskar et al., 2004 evolution
!!! 
!!! Author: RV, JBC
!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

implicit none

  real,save,allocatable :: yearlask(:) ! year before present from Laskar et al. Tab
  real,save,allocatable :: obllask(:)  ! obliquity    [deg]
  real,save,allocatable :: ecclask(:)  ! excentricity [deg]
  real,save,allocatable :: lsplask(:)  ! ls perihelie [deg]
  integer, save         :: last_ilask  ! Index of the line in the file year_obl_lask.asc corresponding to the closest lower year to the current year

contains

  subroutine ini_lask_param_mod
  
  implicit none

  integer :: nlask ! number of lines in Laskar files
  integer :: ierr

  nlask = 0
  open(1,file = 'obl_ecc_lsp.asc')
  do
      read(1,*,iostat = ierr)
      if (ierr /= 0) exit
      nlask = nlask + 1
  enddo
  close(1)
  allocate(yearlask(nlask))
  allocate(obllask(nlask))
  allocate(ecclask(nlask))
  allocate(lsplask(nlask))
  
  end subroutine ini_lask_param_mod


  subroutine end_lask_param_mod

  implicit none

  if (allocated(yearlask)) deallocate(yearlask)
  if (allocated(obllask)) deallocate(obllask)
  if (allocated(ecclask)) deallocate(ecclask)
  if (allocated(lsplask)) deallocate(lsplask)

  end subroutine end_lask_param_mod
  
end module lask_param_mod
