MODULE plasmaphys_venus_mod

!       COMMON/com_plasma/
 
IMPLICIT NONE

!       LOGICAL :: plasma 
!       LOGICAL :: isoT      
       !INTEGER :: ndiffions    ! nombre d'ions decrit
       INTEGER :: nsubstep     ! nombre de sous pas de temps pour le calcul des tendances dynamiques
       INTEGER :: naltvert     ! nombre de points sur la grille altitude pour dynamique verticale
       INTEGER :: nsubvert     ! nombre de sous pas de temps maximal pour dynamique verticale
       INTEGER :: nsubmin      ! nombre de sous pas de temps minimal pour dynamique verticale
!       INTEGER :: iappvert     ! periode appel de dynamique verticale
       !INTEGER :: iz_vertplasma! vertical index above which ion diffusion is computed
!       INTEGER :: irun         ! numero de simulation
!       INTEGER nspecies     ! number of molecular species (different from nqmx if active dust included)
!       REAL :: qcharge,muvide,preffplasma,masseU,melec                     &
!     & ,dtplasma,Freqklim,kbolt
       REAL*8 :: Pdiffion 
       REAL*8 :: qcharge,muvide

!       parameter (ndiffions = 8)
!       parameter (Pdiffion  = 7.D-4) ! pressure in Pa below which ion diffusion is computed
!        ORIGINE -------------------------------
       !parameter (naltvert  = 28)
       !parameter (nsubvert  = 12000)   ! ptimestep/nsubvert
       !parameter ( nsubmin  = 80)    ! ptimestep/nsubmin
!        STABILITY MORE5  ----------------------------------
       !parameter (Pdiffion  = 7.0D-4) ! pressure in Pa below which ion diffusion is computed
       !parameter (naltvert  = 28*3)
       !parameter (nsubvert  = 12000)   ! ptimestep/nsubvert
       !parameter ( nsubmin  = 40)    ! ptimestep/nsubmin
!        STABILITY MORE6  ----------------------------------
       !parameter (Pdiffion  = 7.0D-4) ! pressure in Pa below which ion diffusion is computed
       !parameter (naltvert  = 28*3*2)
       !parameter (nsubvert  = 12000*3)   ! ptimestep/nsubvert
       !parameter ( nsubmin  = 40)    ! ptimestep/nsubmin
!       CURRENT BEST TIME CALCULATION  ----------------------------------
       parameter (Pdiffion  = 7.0D-4) ! pressure in Pa below which ion diffusion is computed
       parameter (naltvert  = 168)    ! number of level on the altimetric subgrid
       parameter (nsubvert  = 24000)  ! ptimephysiq/nsubvert - minimum sub-timestep allowed
       parameter ( nsubmin  = 40)     ! ptimephysiq/nsubmin  - maximum sub-timestep allowed


       !parameter (iappvert  = 500)
       parameter (qcharge=1.602176487D-19)
       !parameter (kbolt=1.3806504d-23)
       parameter (muvide=1.2566371D-6)
       !parameter (preffplasma=1.e-10)
       !parameter (masseU=1.660538782e-27)
       !parameter (melec=9.1093826e-31) 
!       parameter (isoT=.TRUE.)

!! OLDER CODE BELOW ======================================================
       
! Ions parameter 
        
       !INTEGER itrans(ndynions)                  ! global index of fluid ions
       !INTEGER etrans(1)                         ! index of electron    
       !INTEGER,DIMENSION(:),ALLOCATABLE :: iplasma ! = 0 ou 1 si traceur ou fluide 
       !CHARACTER(LEN=20) ionstrans(ndynions)
       !CHARACTER(LEN=20) electrans(1)  
       !REAL,DIMENSION(:),ALLOCATABLE ::  Mtraceur
       !REAL, DIMENSION(:),ALLOCATABLE :: Charge
       !REAL Cpkabs(ndynions),cpk(ndynions),kappak(ndynions)
       !REAL cpeabs,cpe,kappae

!	parameter (ionstrans=["o2plus","oplus"])
!	parameter (electrans=["elec"])

!
!! Dissipation parameters
!
!!       REAL tetaudivk,tetaurotk,tetahk,cdivuk,crotk,cdivhk	
!        REAL,DIMENSION(:),ALLOCATABLE :: tetaudivk,tetaurotk,tetahk
!
!!       COMMON/com_plasma/                                               &
!!     & ionstrans,electrans,irun,                                        &
!!     & plasma,itrans,etrans,iplasma,Mtraceur,dtplasma,Charge,           &
!!     & cpkabs,cpk,kappak,cpeabs,cpe,kappae
!
!!       COMMON/diss_plasma/tetaudivk(llp),tetaurotk(llp),tetahk(llp)
!       	

END MODULE

!-----------------------------------------------------------
