#!/bin/bash
# Partition to run on:
#MSUB -q rome
# project to run on 
#MSUB -A  gen10391
# disks to use
#MSUB -m  scratch,work,store
# Job name
#MSUB -r run_PEM
# Job standard output:
#MSUB -o run_PEM.%I
# Job standard error:
#MSUB -e run_PEM.%I
# number of OpenMP threads c
#MSUB -c 1
# number of MPI tasks n
#MSUB -n 1
# number of nodes to use N
#MSUB -N 1
# max job run time T (in seconds)
#MSUB -T 860
#MSUB -Q test
# request exclusive use of the node (128 cores)
##MSUB -x

# A few parameters that might need be changed depending on your setup:
# Path to the arch.env to source:
source ../trunk/LMDZ.COMMON/arch.env

#------------------ Modify here the name of PEM exe --------------------
## fill in the name of executable for PEM:
exePEM=pem_29_phymars_seq.e

#------------------ Modify here the name of GCM exe --------------------
## fill in the name of executable for GCM:
exeGCM=testphys1d_29_phymars_para.e

#-------------- Modify here the name of reshape XIOS exe ---------------
## fill in the name of executable for reshape XIOS:
exeReshape=reshape_XIOS_output_64x48x29_phymars_seq.e

#---------------- Modify here the number of PEM calls ------------------
## set the number of PEM calls:
nPEM=1000

#---------------- Modify here the number of GCM calls ------------------
## set the number of GCM calls between each PEM call:
nGCM=2



#--------- Check if files/directories exist to be able to run ----------
echo Starting script to call PEM with GCM!
if [ ! -d "profiles" ]; then
    mkdir profiles
else
    rm profiles/*
fi
if [ ! -d "diagfis" ]; then
    mkdir diagfis
else
    rm diagfis/*
fi
if [ ! -d "startfis" ]; then
    mkdir startfis
else
    rm startfis/*
fi
if [ ! -r "context_lmdz_physics.xml" ]; then
    echo File context_lmdz_physics.xml does not exist!
    exit 0
fi
if [ ! -r "field_def_physics_mars.xml" ]; then
    echo File field_def_physics_mars.xml does not exist!
    exit 0
fi
if [ ! -r "file_def_physics_mars.xml" ]; then
    echo File file_def_physics_mars.xml does not exist!
    exit 0
fi
if [ ! -r "iodef.xml" ]; then
    echo File iodef.xml does not exist!
    exit 0
fi
if [ ! -r "run_PEM.def" ]; then
    echo File diagfi_PEM.def does not exist!
    exit 0
fi
if [ ! -r "run_GCM.def" ]; then
    echo File diagfi_GCM.def does not exist!
    exit 0
fi
if [ ! -r "run_PEM.def" ]; then
    echo File diagfi_PEM.def does not exist!
    exit 0
fi
if [ ! -r "run_GCM.def" ]; then
    echo File diagfi_GCM.def does not exist!
    exit 0
fi

#---------------------------- Initialization ---------------------------
iPEM=1
((iGCM = ($iPEM - 1)*$nGCM + 1))
cp startfi.nc startfis/
cp startfi_PEM.nc startfis/
for file in profile_*; do
    cp $file profiles/${file}_0
done

#---------------------- Main loop to call PEM/GCM ----------------------
while [ $iPEM -le $nPEM ]; do
    #--- Loop to run GCM year by year
    cp run_GCM.def run.def
    cp diagfi_GCM.def diagfi.def
    for ((i = 1; i <= $nGCM; i++)); do
        echo Run GCM $iGCM: call $i out of $nGCM...
        ./$exeGCM > lrun${iGCM} 2>&1
        mv diagfi.nc diagfis/diagfi${iGCM}.nc
	cp Xdiurnalave.nc diagfis/Xdiurnalave${iGCM}.nc
        mv Xdiurnalave.nc data2reshape${i}.nc
        cp restartfi.nc startfis/startfi${iGCM}.nc
        mv restartfi.nc startfi.nc
        for file in profile_out_*; do
            cp $file profiles/${file/_out/}_${iGCM}
            mv $file ${file/_out/}
        done
        ((iGCM++))
        echo Done!
    done
    #--- Reshaping GCM data with XIOS
    echo Reshaping GCM data with XIOS...
    for i in $(ls datareshaped*); do
        rm $i
    done
    ./$exeReshape
    for file in datareshaped*; do
        mv $file ${file/reshaped/_GCM_Y}
    done
    echo Done!
     #--- Running PEM
    echo Run PEM $iPEM...
    cp run_PEM.def run.def
    cp diagfi_PEM.def diagfi.def
    mv startfi.nc startfi_evol.nc
    ./$exePEM > mrun${iPEM} 2>&1
    mv diagfi.nc diagfis/diagfi_PEM${iPEM}.nc
    cp restartfi_evol.nc startfis/startfi_postPEM${iPEM}.nc
    mv restartfi_evol.nc startfi.nc
    cp restartfi_PEM.nc startfis/startfi_PEM${iPEM}.nc
    mv restartfi_PEM.nc startfi_PEM.nc
    for file in profile_out_*; do
        cp $file profiles/${file/_out/}PEM_${iPEM}
        mv $file ${file/_out/}
    done
    mv info_run_PEM.txt info_run_PEM${iPEM}.txt
    ((iPEM++))
    echo Done!
done

#---------------------- Preparation for relaunch  ----------------------
echo Reinitializing starting files...
cp startfis/startfi.nc .
for file in profiles/*_0; do
    cp $file ${file/_0/}
done

echo Script finished.
