#!/bin/bash

# Bash script to modify the orbital parameters of a file "startfi.nc"
name_file="startfi.nc"

new_obl=30.0286
new_exc=0.08212066
new_Lsp=347.443947402


# Calculate modified values
year_day=669.
halfaxe=227.94
pi=$(echo "4*a(1)" | bc -l)
degrad=$(echo "360./(2.*$pi)" | bc -l)
tan=$(echo "s(0.5*$new_Lsp/$degrad)/c(0.5*$new_Lsp/$degrad)" | bc -l)
zx0=$(echo "-2.*a($tan*sqrt((1.-$new_exc)/(1.+$new_exc)))" | bc -l)
if [ $(echo "$zx0 <= 0" | bc -l) -eq 1 ]; then
  zx0=$(echo "$zx0 + 2.*$pi" | bc -l)
fi
solp=$(echo "$year_day*(1.-($zx0 - $new_exc*s($zx0))/(2*$pi))" | bc -l)

# Update the netCDF file
# controle(15) = periheli ! min. Sun-Mars distance (Mkm)  ̃206.66
# controle(16) = aphelie  ! max. SUn-Mars distance (Mkm)  ̃249.22
# controle(17) = peri_day ! date of perihelion (sols since N. spring)
# controle(18) = obliquit ! Obliquity of the planet (deg)  ̃23.98
ncap2 -O -s "controle(17)=$new_obl" \
      -s "controle(14)=$halfaxe*(1-$new_exc)" \
      -s "controle(15)=$halfaxe*(1+$new_exc)" \
      -s "controle(16)=$solp" \
      $name_file $name_file.temp

# Rename the temporary file back to the original filename
mv $name_file.temp $name_file

echo New obliquit = $new_obl
echo New periheli = $(echo "$halfaxe*(1-$new_exc)" | bc -l)
echo New aphelie = $(echo "$halfaxe*(1+$new_exc)" | bc -l)
echo New peri_day = $solp
