#!/bin/bash

# Bash script to modify the orbital parameters of a file "startfi.nc"
name_file="startfi.nc"

new_Ls=90.
Lsp=347.443947402


# Extract the 'controle' variable into a temporary file
ncks -v controle $name_file > tmp_controle.txt

# Extract the 'data' block containing the controle values
data_block=$(awk '/data:/ {flag=1} flag; /\}/ {flag=0}' tmp_controle.txt | sed '1d;$d')

# Remove unnecessary characters
data_block=$(echo "$data_block" | sed -e 's/^[ \t]*//')
data_block=$(echo "$data_block" | sed 's/controle =//')
data_block=$(echo "$data_block" | sed 's/;$//')

# Convert the data block into an array
IFS=', ' read -ra controle_values <<< "$data_block"
#for value in "${controle_values[@]}"; do
#    echo "$value"
#done

# Remove the temporary file
rm tmp_controle.txt

# Calculate modified values
halfaxe=227.94
#year_day=668.6
year_day=${controle_values[13]}
peri_day=${controle_values[16]}
pi=$(echo "4*a(1)" | bc -l)
degrad=$(echo "360./(2.*$pi)" | bc -l)
timeperi=$(echo "(1. - $Lsp)/$degrad" | bc -l)
e_elips=$(echo "1.-${controle_values[14]}/$halfaxe" | bc -l)
abs_new_Ls=$(echo "if($new_Ls < 0) -($new_Ls) else $new_Ls" | bc -l)

if [ $(echo "$abs_new_Ls < 0.00001" | bc -l) -eq 1 ]; then
  if [ $(echo "$new_Ls >= 0." | bc -l) -eq 1 ]; then
    new_sol=0.
  else
    new_sol=$year_day
  fi
else 
  zteta=$(echo "$new_Ls/$degrad + $timeperi" | bc -l)
  tan=$(echo "s(0.5*$zteta)/c(0.5*$zteta)" | bc -l)
  zx0=$(echo "2.*a($tan/sqrt((1.+$e_elips)/(1.-$e_elips)))" | bc -l)
  xref=$(echo "$zx0-$e_elips*s($zx0)" | bc -l)
  zz=$(echo "$xref/(2.*$pi)" | bc -l)
  new_sol=$(echo "$zz*$year_day + $peri_day" | bc -l)
  if [ $(echo "$new_sol < 0." | bc -l) -eq 1 ]; then
      new_sol=$(echo "$new_sol + $year_day" | bc -l)
  fi
  if [ $(echo "$new_sol >= $year_day" | bc -l) -eq 1 ]; then
      new_sol=$(echo "$new_sol - $year_day" | bc -l)
  fi
fi

# Update the netCDF file
# tab_cntrl(3) = day_ini + int(time) ! initial day
ncap2 -O -s "controle(2)=$new_sol" \
      $name_file $name_file.temp

# Rename the temporary file back to the original filename
mv $name_file.temp $name_file

echo New initial sol = $new_sol
