#!/bin/bash

# Bash script to modify the orbital parameters of a file "startfi.nc"
name_file="startfi.nc"

new_obl=30.
new_exc=0.
new_Lsp=250.

year_day=669.
halfaxe=227.94


# Calculate modified values
pi=$(echo "4*a(1)" | bc -l)
arg=$(echo "0.5*2.*$pi*$new_Lsp/360." | bc -l)
zx0=$(echo "-2.*-2.0*a(s($arg)/c($arg)*sqrt((1. - $new_exc)/(1. + $new_exc)))" | bc -l)
if [ $(echo "$zx0 < 0" | bc -l) -eq 1 ]; then
  zx0=$(echo "$zx0 + 2.*$pi" | bc -l)
fi
solp=$(echo "$year_day*(1.-($zx0 - $new_exc*s($zx0))/(2*$pi))" | bc -l)

# Update the netCDF file
# controle(15) = periheli ! min. Sun-Mars distance (Mkm)  ̃206.66
# controle(16) = aphelie  ! max. SUn-Mars distance (Mkm)  ̃249.22
# controle(16) = peri_day ! date of perihelion (sols since N. spring)
# controle(18) = obliquit ! Obliquity of the planet (deg)  ̃23.98
ncap2 -O -s "controle(17)=$new_obl" \
      -s "controle(14)=$halfaxe*(1-$new_exc)" \
      -s "controle(15)=$halfaxe*(1+$new_exc)" \
      -s "controle(16)=$solp" \
      $name_file $name_file.temp

# Rename the temporary file back to the original filename
mv $name_file.temp $name_file
