MODULE nlteparams_h

IMPLICIT NONE

!-----------------------------------------------------------------------
!   Parameters which govern the transition from LTE to NLTE radiation
!   tendencies.
!-----------------------------------------------------------------------

real,parameter :: ptrans = 0.1    ! central pressure for transition (Pa)

real,parameter :: zw = 0.5    ! half-width for transition (scale heights)

real,parameter :: pminte  = 0.4*ptrans ! pressure up to which LTE 
! is calculated (Pa) almost one scale height above transition in worst
! case is very safe

real,parameter :: zwi = 2./zw

END MODULE nlteparams_h
