MODULE paleoclimate_mod
!=======================================================================
!   subject: Module dedicated to paleoclimates studies
!   --------
!
!   author: LL, 06/2023
!   ------
!   
!=======================================================================

    IMPLICIT NONE

    LOGICAL :: paleoclimate                        ! False by default, is activate  for paleoclimates specific processes (e.g., lag layer)
    real, save, allocatable :: lag_h2o_ice(:,:)  ! Thickness of the lag before H2O ice [m]
    real, save, allocatable :: lag_co2_ice(:,:)  ! Thickness of the lag before CO2 ice [m]
    real, save :: albedo_perenialco2             ! Albedo for perenial co2 ice [1]
    CONTAINS


  subroutine ini_paleoclimate_h(ngrid,nslope)

  implicit none
  integer,intent(in) :: ngrid  ! number of atmospheric columns
  integer,intent(in) :: nslope ! number of slope within a mesh 

    allocate(lag_h2o_ice(ngrid,nslope))
    allocate(lag_co2_ice(ngrid,nslope))
  end subroutine ini_paleoclimate_h

  subroutine end_paleoclimate_h

  implicit none
    if (allocated(lag_h2o_ice)) deallocate(lag_h2o_ice)
    if (allocated(lag_co2_ice)) deallocate(lag_co2_ice)
  end subroutine end_paleoclimate_h


    END MODULE paleoclimate_mod
