MODULE conf_pem_mod

!=======================================================================
!
! Purpose: Read the parameter for a PEM run in run_pem.def
!
! Author: RV 
!=======================================================================

IMPLICIT NONE

CONTAINS

  SUBROUTINE conf_pem

#ifdef CPP_IOIPSL
  use IOIPSL, only: getin
#else
  ! if not using IOIPSL, we still need to use (a local version of) getin
  use ioipsl_getincom, only: getin
#endif
  
  USE temps_mod_evol, ONLY: year_bp_ini, dt_pem, water_ice_criterion, co2_ice_criterion, ps_criterion, &
                Max_iter_pem, evol_orbit_pem, var_obl, var_ex, var_lsp
  USE comsoil_h_pem, only: soil_pem,fluxgeo,water_reservoir_nom,depth_breccia,depth_bedrock,reg_thprop_dependp 
  USE adsorption_mod,only: adsorption_pem
  USE glaciers_mod, only: co2glaciersflow,h2oglaciersflow
  use ice_table_mod, only: icetable_equilibrium, icetable_dynamic 

  CHARACTER(len=20),parameter :: modname ='conf_pem' 

!PEM parameters

! #---------- ORBITAL parameters --------------#

  evol_orbit_pem=.false.
  CALL getin('evol_orbit_pem', evol_orbit_pem)

  year_bp_ini=0.
  CALL getin('year_bp_ini', year_bp_ini)

  var_obl = .true.
  CALL getin('var_obl',var_obl)
  print*,'Does obliquity vary ?',var_obl

  var_ex = .true.
  CALL getin('var_ex',var_ex)
  print*,'Does excentricity vary ?',var_ex

  var_lsp = .true.
  CALL getin('var_lsp',var_lsp)
  print*,'Does Ls peri vary ?',var_lsp

! #---------- Stopping criterion parameters --------------#

  Max_iter_pem=99999999
  CALL getin('Max_iter_pem', Max_iter_pem)

  water_ice_criterion=0.2
  CALL getin('water_ice_criterion', water_ice_criterion)

  co2_ice_criterion=0.2
  CALL getin('co2_ice_criterion', co2_ice_criterion)

  ps_criterion = 0.15
  CALL getin('ps_criterion',ps_criterion)

  dt_pem=1
  CALL getin('dt_pem', dt_pem)

! #---------- Subsurface parameters --------------#

  soil_pem=.true.
  CALL getin('soil_pem', soil_pem)

  adsorption_pem = .true.
  CALL getin('adsorption_pem',adsorption_pem)

  co2glaciersflow = .true.
  CALL getin('co2glaciersflow', co2glaciersflow)

  h2oglaciersflow = .true.
  CALL getin('h2oglaciersflow', h2oglaciersflow)

  reg_thprop_dependp = .false.
  CALL getin('reg_thprop_dependp',reg_thprop_dependp)
  print*, 'Thermal properties of the regolith vary with pressure ?', reg_thprop_dependp

! #---------- Layering parameters --------------#

  fluxgeo = 0.
  CALL getin('Fluxgeo_PEM',fluxgeo)
  print*,'Flux Geothermal is set to',fluxgeo
   
  depth_breccia   = 10.
  CALL getin('depth_breccia',depth_breccia)
  print*,'Depth of breccia is set to',depth_breccia

  depth_bedrock   = 1000.
  CALL getin('depth_bedrock',depth_bedrock)
  print*,'Depth of bedrock is set to',depth_bedrock

   icetable_equilibrium = .true.
   CALL getin('icetable_equilibrium',icetable_equilibrium)
   print*, 'Do we compute the ice table at equilibrium?', icetable_equilibrium

   icetable_dynamic = .false.
   CALL getin('icetable_dynamic',icetable_dynamic)
   print*, 'Do we compute the ice table with the dynamic method?', icetable_dynamic

  if ((.not.soil_pem).and.((icetable_equilibrium).or.(icetable_dynamic))) then
       print*,'Ice table  must be used when soil_pem = T'
       call abort_physic(modname,"Ice table  must be used when soil_pem = T",1)
  endif

  if ((.not.soil_pem).and.adsorption_pem) then
       print*,'Adsorption must be used when soil_pem = T'
       call abort_physic(modname,"Adsorption must be used when soil_pem = T",1)
  endif
  
  if ((.not.soil_pem).and.(fluxgeo.gt.0.)) then
       print*,'Soil is not activated but Flux Geo > 0.'
       call abort_physic(modname,"Soil is not activated but Flux Geo > 0.",1)
  endif
 
  if ((.not.soil_pem).and.reg_thprop_dependp) then
     print*,'Regolith properties vary with Ps only when soil is set to true'
     call abort_physic(modname,'Regolith properties vary with Ps only when soil is set to true',1)
  endif

  if (evol_orbit_pem.and.year_bp_ini.eq.0.) then
     print*,'You want to follow the file ob_ex_lsp.asc for changing orb parameters,'
     print*,'but you did not specify from which year to start.'
     call abort_physic(modname,"evol_orbit_pem=.true. but year_bp_ini=0",1)
  endif 

  water_reservoir_nom = 1e4
  CALL getin('water_reservoir_nom',water_reservoir_nom)

  END SUBROUTINE conf_pem

END MODULE conf_pem_mod
