module lask_param_mod
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!
!!! Purpose: Define parameters from Laskar et al., 2004 evolution
!!! 
!!! Author: RV
!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

implicit none

  real,save,allocatable :: yearlask(:)          ! year before present from Laskar et al. Tab
  real,save,allocatable :: oblask(:)            ! obliquity    [deg]
  real,save,allocatable :: exlask(:)            ! excentricity [deg]
  real,save,allocatable :: lsplask(:)           ! ls perihelie [deg]
  integer, save :: last_ilask                   ! Index of the line in the file year_obl_lask.asc corresponding to the closest lower year to the current year

contains

  subroutine ini_lask_param_mod(nlask)
  
  implicit none
  integer,intent(in) :: nlask ! number of line
  
  allocate(yearlask(nlask))
  allocate(oblask(nlask))
  allocate(exlask(nlask))
  allocate(lsplask(nlask))
  
  end subroutine ini_lask_param_mod


  subroutine end_lask_param_mod

  implicit none

  if (allocated(yearlask)) deallocate(yearlask)
  if (allocated(oblask)) deallocate(oblask)
  if (allocated(exlask)) deallocate(exlask)
  if (allocated(lsplask)) deallocate(lsplask)

  end subroutine end_lask_param_mod
  
end module lask_param_mod
