SUBROUTINE info_run_PEM(year_iter, criterion_stop)

!=======================================================================
!
! Purpose: Write in a file called info_run_PEM.txt the reason why the PEM did stop and the number of extrapolation year done
!
! Author: RV 
!=======================================================================

   IMPLICIT NONE

  INTEGER, intent(in) :: year_iter, criterion_stop ! # of year and reason to stop

  logical :: exist

  inquire(file='info_run_PEM.txt', exist=exist)
  if (exist) then
    open(12, file='info_run_PEM.txt', status="old", position="append", action="write")
  else
    open(12, file='info_run_PEM.txt', status="new", action="write")
  end if
  write(12, *) year_iter, criterion_stop
  close(12)

END SUBROUTINE info_run_PEM
